/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcessDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class BpmnSubProcessDiagramCreationContributor
implements IDiagramWizardContributor {
    public boolean accept(IElement owner) {
        if (owner != null) {
            for (Class metaclass : this.getAllowedMetaclasses()) {
                if (!metaclass.isAssignableFrom(owner.getClass())) continue;
                IElementStatus elementStatus = owner.getElementStatus();
                return elementStatus.isCmsNode() || elementStatus.isModifiable();
            }
        }
        return false;
    }

    public IAbstractDiagram actionPerformed(IModelElement diagramContext, String diagramName, String diagramDescription) {
        IModelingSession modelingSession = Modelio.getInstance().getModelingSession();
        IBpmnSubProcessDiagram diagram = this.createBpmnSubProcessDiagram(modelingSession, diagramContext);
        if (diagram != null) {
            try {
                diagram.putNoteContent("description", diagramDescription);
            }
            catch (NoteTypeNotFoundException e) {
                DiagramEditor.LOG.warning((Throwable)e);
            }
        }
        return diagram;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        ArrayList<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        allowedMetaclasses.add(IBpmnSubProcess.class);
        return allowedMetaclasses;
    }

    private IBpmnSubProcessDiagram createBpmnSubProcessDiagram(IModelingSession modelingSession, IModelElement diagramContext) {
        IBpmnSubProcessDiagram diagram = (IBpmnSubProcessDiagram)modelingSession.getModel().createElement("BpmnSubProcessDiagram");
        diagram.setOrigin(diagramContext);
        DefaultNameFactory.setDefaultName((IAbstractDiagram)diagram);
        return diagram;
    }

    public String getCommandName() {
        return DiagramEditor.I18N.getString("UmlWizard.BpmnSubProcess.Name");
    }

    public Image getImage() {
        return StandardImageService.getMetaclassImage(IBpmnSubProcessDiagram.class);
    }

    public String getInformation() {
        return DiagramEditor.I18N.getString("UmlWizard.BpmnSubProcess.Information");
    }

    public String getHelpUrl() {
        return null;
    }

    public String getDetails() {
        return DiagramEditor.I18N.getString("UmlWizard.BpmnSubProcess.Details");
    }
}

