/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.ICommunicationDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationNode;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.usecase.IActor;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCase;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class CommunicationDiagramCreationContributor
implements IDiagramWizardContributor {
    public boolean accept(IElement owner) {
        if (owner != null) {
            for (Class metaclass : this.getAllowedMetaclasses()) {
                if (!metaclass.isAssignableFrom(owner.getClass())) continue;
                IElementStatus elementStatus = owner.getElementStatus();
                return elementStatus.isCmsNode() || elementStatus.isModifiable();
            }
        }
        return false;
    }

    public IAbstractDiagram actionPerformed(IModelElement diagramContext, String diagramName, String diagramDescription) {
        ICommunicationDiagram diagram = null;
        ICommunicationInteraction interaction = null;
        ICollaboration locals = null;
        IModelingSession modelingSession = Modelio.getInstance().getModelingSession();
        if (diagramContext instanceof ICommunicationInteraction) {
            interaction = (ICommunicationInteraction)diagramContext;
            if (interaction.cardOwnedCollaboration() > 0) {
                locals = (ICollaboration)interaction.getOwnedCollaboration().get(0);
            } else {
                this.checkLocalCollaboration(modelingSession, interaction);
            }
        } else {
            interaction = (ICommunicationInteraction)modelingSession.getModel().createElement("CommunicationInteraction", (IElement)diagramContext, "OwnedBehavior");
            DefaultNameFactory.setDefaultName((IModelElement)interaction);
            locals = this.checkLocalCollaboration(modelingSession, interaction);
        }
        diagram = diagramContext instanceof IClassifier && !(diagramContext instanceof IUseCase) ? this.smartCreateForClassifier(modelingSession, interaction, locals, (IClassifier)diagramContext, diagramName) : (diagramContext instanceof IOperation ? this.smartCreateForOperation(modelingSession, interaction, locals, (IOperation)diagramContext, diagramName) : this.smartCreateForNameSpace(modelingSession, interaction, diagramName));
        if (diagram != null) {
            try {
                diagram.putNoteContent("description", diagramDescription);
            }
            catch (NoteTypeNotFoundException e) {
                DiagramEditor.LOG.warning((Throwable)e);
            }
        }
        return diagram;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        ArrayList<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        allowedMetaclasses.add(IPackage.class);
        allowedMetaclasses.add(IClass.class);
        allowedMetaclasses.add(IInterface.class);
        allowedMetaclasses.add(ISignal.class);
        allowedMetaclasses.add(IActor.class);
        allowedMetaclasses.add(IComponent.class);
        allowedMetaclasses.add(INode.class);
        allowedMetaclasses.add(IUseCase.class);
        allowedMetaclasses.add(ICollaboration.class);
        allowedMetaclasses.add(IOperation.class);
        allowedMetaclasses.add(ICommunicationInteraction.class);
        return allowedMetaclasses;
    }

    private ICommunicationDiagram createCommunicationDiagram(IModelingSession modelingSession, ICommunicationInteraction diagramContext, String diagramName) {
        ICommunicationDiagram diagram;
        try {
            diagram = modelingSession.getModel().createCommunicationDiagram(diagramName, (IModelElement)diagramContext, null);
        }
        catch (StereotypeNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return diagram;
    }

    private ICommunicationDiagram smartCreateForClassifier(IModelingSession modelingSession, ICommunicationInteraction interaction, ICollaboration locals, IClassifier parentClassifier, String diagramName) {
        IBindableInstance instance;
        ICommunicationInteraction diagramContext = interaction;
        ICommunicationDiagram diagram = this.createCommunicationDiagram(modelingSession, diagramContext, diagramName);
        if (diagram != null && (instance = (IBindableInstance)modelingSession.getModel().createElement("BindableInstance", (IElement)locals, "Declared")) != null) {
            instance.setName("this");
            instance.setBase((INameSpace)parentClassifier);
            ICommunicationNode node = (ICommunicationNode)modelingSession.getModel().createElement("CommunicationNode", (IElement)interaction, "Owned");
            if (node != null) {
                node.setName("this");
                node.setRepresented((IInstance)instance);
            }
        }
        return diagram;
    }

    private ICommunicationDiagram smartCreateForNameSpace(IModelingSession modelingSession, ICommunicationInteraction interaction, String diagramName) {
        ICommunicationInteraction diagramContext = interaction;
        return this.createCommunicationDiagram(modelingSession, diagramContext, diagramName);
    }

    private ICommunicationDiagram smartCreateForOperation(IModelingSession modelingSession, ICommunicationInteraction interaction, ICollaboration locals, IOperation parentOperation, String diagramName) {
        IBindableInstance instance;
        ICommunicationInteraction diagramContext = interaction;
        ICommunicationDiagram diagram = this.createCommunicationDiagram(modelingSession, diagramContext, diagramName);
        if (diagram != null && (instance = (IBindableInstance)modelingSession.getModel().createElement("BindableInstance", (IElement)locals, "Declared")) != null) {
            instance.setName("this");
            instance.setBase((INameSpace)parentOperation.getOwner());
            ICommunicationNode node = (ICommunicationNode)modelingSession.getModel().createElement("CommunicationNode", (IElement)interaction, "Owned");
            if (node != null) {
                node.setName("this");
                node.setRepresented((IInstance)instance);
            }
        }
        return diagram;
    }

    private ICollaboration checkLocalCollaboration(IModelingSession modelingSession, ICommunicationInteraction interaction) {
        ICollaboration locals = null;
        Iterator iterator = interaction.getOwnedCollaboration().iterator();
        if (iterator.hasNext()) {
            ICollaboration collab;
            locals = collab = (ICollaboration)iterator.next();
        }
        if (locals == null) {
            locals = (ICollaboration)modelingSession.getModel().createElement("Collaboration", (IElement)interaction, "OwnedCollaboration");
            locals.setName("locals");
        }
        return locals;
    }

    public String getCommandName() {
        return DiagramEditor.I18N.getString("UmlWizard.Communication.Name");
    }

    public Image getImage() {
        return StandardImageService.getMetaclassImage(ICommunicationDiagram.class);
    }

    public String getInformation() {
        return DiagramEditor.I18N.getString("UmlWizard.Communication.Information");
    }

    public String getHelpUrl() {
        return null;
    }

    public String getDetails() {
        return DiagramEditor.I18N.getString("UmlWizard.Communication.Details");
    }
}

