/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.ICompositeStructureDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IStaticDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class CompositeDiagramCreationContributor
implements IDiagramWizardContributor {
    public boolean accept(IElement owner) {
        if (owner != null) {
            for (Class metaclass : this.getAllowedMetaclasses()) {
                if (!metaclass.isAssignableFrom(owner.getClass())) continue;
                IElementStatus elementStatus = owner.getElementStatus();
                return elementStatus.isCmsNode() || elementStatus.isModifiable();
            }
        }
        return false;
    }

    public IAbstractDiagram actionPerformed(IModelElement diagramContext, String diagramName, String diagramDescription) {
        IStaticDiagram diagram = this.createCompositeDiagram(Modelio.getInstance().getModelingSession(), diagramName, diagramContext);
        if (diagram != null) {
            try {
                diagram.putNoteContent("description", diagramDescription);
            }
            catch (NoteTypeNotFoundException e) {
                DiagramEditor.LOG.warning((Throwable)e);
            }
        }
        return diagram;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        ArrayList<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        allowedMetaclasses.add(ICollaboration.class);
        allowedMetaclasses.add(IClass.class);
        allowedMetaclasses.add(INode.class);
        return allowedMetaclasses;
    }

    private IStaticDiagram createCompositeDiagram(IModelingSession modelingSession, String diagramName, IModelElement diagramContext) {
        IStaticDiagram diagram = (IStaticDiagram)modelingSession.getModel().createElement("CompositeStructureDiagram");
        diagram.setName(diagramName);
        diagram.setOrigin(diagramContext);
        return diagram;
    }

    public String getCommandName() {
        return DiagramEditor.I18N.getString("UmlWizard.Composite.Name");
    }

    public Image getImage() {
        return StandardImageService.getMetaclassImage(ICompositeStructureDiagram.class);
    }

    public String getInformation() {
        return DiagramEditor.I18N.getString("UmlWizard.Composite.Information");
    }

    public String getHelpUrl() {
        return null;
    }

    public String getDetails() {
        return DiagramEditor.I18N.getString("UmlWizard.Composite.Details");
    }
}

