/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IDeploymentDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IStaticDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class DeploymentDiagramCreationContributor
implements IDiagramWizardContributor {
    public boolean accept(IElement owner) {
        if (owner != null) {
            for (Class metaclass : this.getAllowedMetaclasses()) {
                if (!metaclass.isAssignableFrom(owner.getClass())) continue;
                IElementStatus elementStatus = owner.getElementStatus();
                return elementStatus.isCmsNode() || elementStatus.isModifiable();
            }
        }
        return false;
    }

    public IAbstractDiagram actionPerformed(IModelElement diagramContext, String diagramName, String diagramDescription) {
        IModelingSession modelingSession = Modelio.getInstance().getModelingSession();
        IStaticDiagram diagram = this.createDeploymentDiagram(modelingSession, diagramName, diagramContext);
        if (diagram != null) {
            try {
                diagram.putNoteContent("description", diagramDescription);
            }
            catch (NoteTypeNotFoundException e) {
                DiagramEditor.LOG.warning((Throwable)e);
            }
        }
        return diagram;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        ArrayList<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        allowedMetaclasses.add(IArtifact.class);
        allowedMetaclasses.add(IPackage.class);
        allowedMetaclasses.add(IClass.class);
        allowedMetaclasses.add(IComponent.class);
        allowedMetaclasses.add(INode.class);
        return allowedMetaclasses;
    }

    private IStaticDiagram createDeploymentDiagram(IModelingSession modelingSession, String diagramName, IModelElement diagramContext) {
        IDeploymentDiagram diagram;
        try {
            diagram = modelingSession.getModel().createDeploymentDiagram(diagramName, diagramContext, null);
        }
        catch (StereotypeNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return diagram;
    }

    public String getCommandName() {
        return DiagramEditor.I18N.getString("UmlWizard.Deployment.Name");
    }

    public Image getImage() {
        return StandardImageService.getMetaclassImage(IDeploymentDiagram.class);
    }

    public String getInformation() {
        return DiagramEditor.I18N.getString("UmlWizard.Deployment.Information");
    }

    public String getHelpUrl() {
        return null;
    }

    public String getDetails() {
        return DiagramEditor.I18N.getString("UmlWizard.Deployment.Details");
    }
}

