/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IObjectDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IStaticDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class ObjectDiagramCreationContributor
implements IDiagramWizardContributor {
    public boolean accept(IElement owner) {
        if (owner != null) {
            for (Class metaclass : this.getAllowedMetaclasses()) {
                if (!metaclass.isAssignableFrom(owner.getClass())) continue;
                IElementStatus elementStatus = owner.getElementStatus();
                return elementStatus.isCmsNode() || elementStatus.isModifiable();
            }
        }
        return false;
    }

    public IAbstractDiagram actionPerformed(IModelElement diagramContext, String diagramName, String diagramDescription) {
        IStaticDiagram diagram = this.createObjectDiagram(Modelio.getInstance().getModelingSession(), diagramName, diagramContext);
        if (diagram != null) {
            try {
                diagram.putNoteContent("description", diagramDescription);
            }
            catch (NoteTypeNotFoundException e) {
                DiagramEditor.LOG.warning((Throwable)e);
            }
        }
        return diagram;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        ArrayList<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        allowedMetaclasses.add(IArtifact.class);
        allowedMetaclasses.add(IBindableInstance.class);
        allowedMetaclasses.add(IClass.class);
        allowedMetaclasses.add(ICollaboration.class);
        allowedMetaclasses.add(IComponent.class);
        allowedMetaclasses.add(IInstance.class);
        allowedMetaclasses.add(INode.class);
        allowedMetaclasses.add(IPackage.class);
        return allowedMetaclasses;
    }

    private IStaticDiagram createObjectDiagram(IModelingSession modelingSession, String diagramName, IModelElement diagramContext) {
        IObjectDiagram diagram;
        try {
            diagram = modelingSession.getModel().createObjectDiagram(diagramName, diagramContext, null);
        }
        catch (StereotypeNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return diagram;
    }

    public String getCommandName() {
        return DiagramEditor.I18N.getString("UmlWizard.Object.Name");
    }

    public Image getImage() {
        return StandardImageService.getMetaclassImage(IObjectDiagram.class);
    }

    public String getInformation() {
        return DiagramEditor.I18N.getString("UmlWizard.Object.Information");
    }

    public String getHelpUrl() {
        return null;
    }

    public String getDetails() {
        return DiagramEditor.I18N.getString("UmlWizard.Object.Details");
    }
}

