/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.ISequenceDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.usecase.IActor;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCase;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class SequenceDiagramCreationContributor
implements IDiagramWizardContributor {
    public boolean accept(IElement owner) {
        if (owner != null) {
            for (Class metaclass : this.getAllowedMetaclasses()) {
                if (!metaclass.isAssignableFrom(owner.getClass())) continue;
                IElementStatus elementStatus = owner.getElementStatus();
                return elementStatus.isCmsNode() || elementStatus.isModifiable();
            }
        }
        return false;
    }

    public IAbstractDiagram actionPerformed(IModelElement diagramContext, String diagramName, String diagramDescription) {
        IModelingSession modelingSession = Modelio.getInstance().getModelingSession();
        ISequenceDiagram diagram = null;
        IInteraction interaction = null;
        if (diagramContext instanceof IInteraction) {
            interaction = (IInteraction)diagramContext;
        } else {
            interaction = (IInteraction)modelingSession.getModel().createElement("Interaction", (IElement)diagramContext, "OwnedBehavior");
            DefaultNameFactory.setDefaultName((IModelElement)interaction);
        }
        if (interaction != null) {
            diagram = diagramContext instanceof IClassifier && !(diagramContext instanceof IUseCase) ? this.smartCreateForClassifier(modelingSession, interaction, (IClassifier)diagramContext, diagramName) : (diagramContext instanceof IOperation ? this.smartCreateForOperation(modelingSession, interaction, (IOperation)diagramContext, diagramName) : this.smartCreateForNameSpace(modelingSession, interaction, diagramName));
        }
        if (diagram != null) {
            try {
                diagram.putNoteContent("description", diagramDescription);
            }
            catch (NoteTypeNotFoundException e) {
                DiagramEditor.LOG.warning((Throwable)e);
            }
        }
        return diagram;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        ArrayList<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        allowedMetaclasses.add(IPackage.class);
        allowedMetaclasses.add(IClass.class);
        allowedMetaclasses.add(IInterface.class);
        allowedMetaclasses.add(ISignal.class);
        allowedMetaclasses.add(IActor.class);
        allowedMetaclasses.add(IComponent.class);
        allowedMetaclasses.add(INode.class);
        allowedMetaclasses.add(IUseCase.class);
        allowedMetaclasses.add(ICollaboration.class);
        allowedMetaclasses.add(IOperation.class);
        allowedMetaclasses.add(IInteraction.class);
        return allowedMetaclasses;
    }

    private ISequenceDiagram createSequenceDiagram(IModelingSession modelingSession, String diagramName, IModelElement diagramContext) {
        ISequenceDiagram diagram = modelingSession.getModel().createSequenceDiagram();
        diagram.setName(diagramName);
        diagram.setOrigin(diagramContext);
        return diagram;
    }

    private ISequenceDiagram smartCreateForClassifier(IModelingSession modelingSession, IInteraction interaction, IClassifier parentClassifier, String diagramName) {
        IBindableInstance instance;
        ICollaboration locals;
        IInteraction diagramContext = interaction;
        ISequenceDiagram diagram = this.createSequenceDiagram(modelingSession, diagramName, (IModelElement)diagramContext);
        if (diagram != null && (locals = this.checkLocalCollaboration(modelingSession, interaction)) != null && (instance = (IBindableInstance)modelingSession.getModel().createElement("BindableInstance", (IElement)locals, "Declared")) != null) {
            instance.setName("this");
            instance.setBase((INameSpace)parentClassifier);
            ILifeline lifeline = (ILifeline)modelingSession.getModel().createElement("Lifeline", (IElement)interaction, "OwnedLine");
            if (lifeline != null) {
                lifeline.setName("this");
                lifeline.setRepresented((IInstance)instance);
            }
        }
        return diagram;
    }

    private ISequenceDiagram smartCreateForNameSpace(IModelingSession modelingSession, IInteraction interaction, String diagramName) {
        IInteraction diagramContext = interaction;
        ISequenceDiagram diagram = this.createSequenceDiagram(modelingSession, diagramName, (IModelElement)diagramContext);
        if (diagram != null) {
            this.checkLocalCollaboration(modelingSession, interaction);
        }
        return diagram;
    }

    private ISequenceDiagram smartCreateForOperation(IModelingSession modelingSession, IInteraction interaction, IOperation parentOperation, String diagramName) {
        IBindableInstance instance;
        ICollaboration locals;
        IInteraction diagramContext = interaction;
        ISequenceDiagram diagram = this.createSequenceDiagram(modelingSession, diagramName, (IModelElement)diagramContext);
        if (diagram != null && (locals = this.checkLocalCollaboration(modelingSession, interaction)) != null && (instance = (IBindableInstance)modelingSession.getModel().createElement("BindableInstance", (IElement)locals, "Declared")) != null) {
            instance.setName("this");
            instance.setBase((INameSpace)parentOperation.getOwner());
            ILifeline lifeline = (ILifeline)modelingSession.getModel().createElement("Lifeline", (IElement)interaction, "OwnedLine");
            if (lifeline != null) {
                lifeline.setName("this");
                lifeline.setRepresented((IInstance)instance);
            }
        }
        return diagram;
    }

    public String getCommandName() {
        return DiagramEditor.I18N.getString("UmlWizard.Sequence.Name");
    }

    public Image getImage() {
        return StandardImageService.getMetaclassImage(ISequenceDiagram.class);
    }

    public String getInformation() {
        return DiagramEditor.I18N.getString("UmlWizard.Sequence.Information");
    }

    public String getHelpUrl() {
        return null;
    }

    public String getDetails() {
        return DiagramEditor.I18N.getString("UmlWizard.Sequence.Details");
    }

    private ICollaboration checkLocalCollaboration(IModelingSession modelingSession, IInteraction interaction) {
        ICollaboration locals = null;
        Iterator iterator = interaction.getOwnedCollaboration().iterator();
        if (iterator.hasNext()) {
            ICollaboration collab;
            locals = collab = (ICollaboration)iterator.next();
        }
        if (locals == null) {
            locals = (ICollaboration)modelingSession.getModel().createElement("Collaboration", (IElement)interaction, "OwnedCollaboration");
            locals.setName("locals");
        }
        return locals;
    }
}

