/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IStateMachineDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.usecase.IActor;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCase;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class StateDiagramCreationContributor
implements IDiagramWizardContributor {
    public boolean accept(IElement owner) {
        if (owner != null) {
            for (Class metaclass : this.getAllowedMetaclasses()) {
                if (!metaclass.isAssignableFrom(owner.getClass())) continue;
                IElementStatus elementStatus = owner.getElementStatus();
                return elementStatus.isCmsNode() || elementStatus.isModifiable();
            }
        }
        return false;
    }

    public IAbstractDiagram actionPerformed(IModelElement diagramContext, String diagramName, String diagramDescription) {
        IStateMachine stateMachine;
        IModelingSession modelingSession = Modelio.getInstance().getModelingSession();
        IStateMachineDiagram stateDiagram = null;
        if (diagramContext instanceof IStateMachine) {
            stateMachine = (IStateMachine)diagramContext;
        } else {
            stateMachine = (IStateMachine)modelingSession.getModel().createElement("StateMachine", (IElement)diagramContext, "OwnedBehavior");
            DefaultNameFactory.setDefaultName((IModelElement)stateMachine);
            modelingSession.getModel().createElement("Region", (IElement)stateMachine, "Top");
        }
        if (stateMachine != null) {
            stateDiagram = this.createStateDiagram(modelingSession, diagramName, (IModelElement)stateMachine);
        }
        if (stateDiagram != null) {
            try {
                stateDiagram.putNoteContent("description", diagramDescription);
            }
            catch (NoteTypeNotFoundException e) {
                DiagramEditor.LOG.warning("org.modelio.diagram.editor", new Object[]{e});
            }
        }
        return stateDiagram;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        ArrayList<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        allowedMetaclasses.add(IPackage.class);
        allowedMetaclasses.add(IClass.class);
        allowedMetaclasses.add(IInterface.class);
        allowedMetaclasses.add(ISignal.class);
        allowedMetaclasses.add(IActor.class);
        allowedMetaclasses.add(IComponent.class);
        allowedMetaclasses.add(INode.class);
        allowedMetaclasses.add(IUseCase.class);
        allowedMetaclasses.add(ICollaboration.class);
        allowedMetaclasses.add(IOperation.class);
        allowedMetaclasses.add(IStateMachine.class);
        return allowedMetaclasses;
    }

    private IStateMachineDiagram createStateDiagram(IModelingSession modelingSession, String diagramName, IModelElement diagramContext) {
        try {
            IStateMachineDiagram stateDiagram = modelingSession.getModel().createStateMachineDiagram(diagramName, diagramContext, null);
            return stateDiagram;
        }
        catch (StereotypeNotFoundException e) {
            return null;
        }
    }

    public String getCommandName() {
        return DiagramEditor.I18N.getString("UmlWizard.State.Name");
    }

    public Image getImage() {
        return StandardImageService.getMetaclassImage(IStateMachineDiagram.class);
    }

    public String getInformation() {
        return DiagramEditor.I18N.getString("UmlWizard.State.Information");
    }

    public String getHelpUrl() {
        return null;
    }

    public String getDetails() {
        return DiagramEditor.I18N.getString("UmlWizard.State.Details");
    }
}

