/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.ContributionModel;
import com.modeliosoft.modelio.api.ui.diagramcreation.DiagramWizardDialog;
import com.modeliosoft.modelio.api.ui.diagramcreation.DiagramWizardModel;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.ActivityDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.BpmnProcessCollaborationDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.BpmnSubProcessDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.ClassDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.CommunicationDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.CompositeDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.DeploymentDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.ObjectDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.SequenceDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.StateDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.handlers.umlwizard.UseCaseDiagramCreationContributor;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class UmlDiagramCreationCommand
extends AbstractHandler {
    private final List<IDiagramWizardContributor> diagrams = new ArrayList();

    public UmlDiagramCreationCommand() {
        this.diagrams.add(new ActivityDiagramCreationContributor());
        this.diagrams.add(new BpmnProcessCollaborationDiagramCreationContributor());
        this.diagrams.add(new BpmnSubProcessDiagramCreationContributor());
        this.diagrams.add(new ClassDiagramCreationContributor());
        this.diagrams.add(new CommunicationDiagramCreationContributor());
        this.diagrams.add(new CompositeDiagramCreationContributor());
        this.diagrams.add(new DeploymentDiagramCreationContributor());
        this.diagrams.add(new ObjectDiagramCreationContributor());
        this.diagrams.add(new SequenceDiagramCreationContributor());
        this.diagrams.add(new StateDiagramCreationContributor());
        this.diagrams.add(new UseCaseDiagramCreationContributor());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDiagramWizardContributor selectedContributors;
        IModelElement selectedElement = this.getSelectedElement();
        DiagramWizardModel dataModel = new DiagramWizardModel();
        dataModel.setContext(selectedElement);
        dataModel.setShowInvalidDiagram(true);
        ContributionModel contribModel = new ContributionModel();
        contribModel.addDiagramContributors(this.diagrams);
        DiagramWizardDialog dialog = new DiagramWizardDialog(Display.getDefault().getActiveShell(), contribModel, dataModel);
        dialog.open();
        DiagramWizardModel resultModel = dialog.getResultModel();
        if (resultModel != null && (selectedContributors = resultModel.getSelectedContributor()) != null) {
            IModelingSession modelingSession = DiagramEditor.getInstance().getModelingSession();
            ITransaction t = modelingSession.getTransactionManager().createTransaction("Create diagram");
            try {
                try {
                    IAbstractDiagram diagram = selectedContributors.actionPerformed(resultModel.getContext(), resultModel.getName(), resultModel.getDescription());
                    modelingSession.getTransactionManager().commit(t);
                    t = null;
                    Modelio.getInstance().getEditionService().openEditor(diagram);
                }
                catch (InvalidTransactionException e) {
                    t = null;
                    if (t != null) {
                        modelingSession.getTransactionManager().rollback(t);
                        t = null;
                    }
                }
            }
            finally {
                if (t != null) {
                    modelingSession.getTransactionManager().rollback(t);
                    t = null;
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IModelElement selectedElement = this.getSelectedElement();
        if (selectedElement != null && !selectedElement.getElementStatus().isRamcObject()) {
            for (IDiagramWizardContributor contributor : this.diagrams) {
                if (!contributor.accept((IElement)selectedElement)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHandled() {
        return true;
    }

    private IModelElement getSelectedElement() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object selectedObject : selectedObjects) {
                IModelElement element = (IModelElement)((IAdaptable)selectedObject).getAdapter(IElement.class);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }
}

