/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.unmask;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.diagram.editor.ScalableFreeformRootEditPart2;
import com.modeliosoft.modelio.diagram.editor.handlers.unmask.LinkPositionSet;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.HandleBounds;

public class UnmaskManager {
    private static final int VERTICAL_OFFSET = 120;
    private static final int HORIZONTAL_OFFSET = 200;

    public void unmaskChildLink(EditPartViewer viewer, GmModel gmModel) {
        IElement elt = gmModel.getRepresentedIElement();
        if (elt != null) {
            ArrayList<IGeneralization> toUnmask = new ArrayList<IGeneralization>();
            if (elt instanceof INameSpace) {
                INameSpace ns = (INameSpace)elt;
                for (IGeneralization link : ns.getSpecialization()) {
                    toUnmask.add(link);
                }
            }
            if (elt instanceof IInterface) {
                IInterface itf = (IInterface)elt;
                for (IGeneralization link : itf.getImplementedLink()) {
                    toUnmask.add(link);
                }
            }
            Rectangle bounds = this.getBounds(viewer, gmModel);
            Point initialPosition = new Point(bounds.x + bounds.width / 2 - 200 * (toUnmask.size() - 1) / 2, bounds.y + bounds.height + 120);
            ((ScalableFreeformRootEditPart2)viewer.getRootEditPart()).getFigure().translateToParent((Translatable)initialPosition);
            this.layoutHorizontal(initialPosition, viewer, toUnmask);
        }
    }

    public void unmaskConstraints(EditPartViewer viewer, GmModel gmModel) {
        IElement elt = gmModel.getRepresentedIElement();
        if (elt != null && elt instanceof IModelElement) {
            ArrayList toUnmask = new ArrayList();
            IModelElement modelElement = (IModelElement)elt;
            toUnmask.addAll(modelElement.getConstraintDefinition());
            Rectangle bounds = this.getBounds(viewer, gmModel);
            Point initialPosition = new Point(bounds.x + bounds.width + 100, bounds.y);
            ((ScalableFreeformRootEditPart2)viewer.getRootEditPart()).getFigure().translateToParent((Translatable)initialPosition);
            this.layoutVertical(initialPosition, viewer, toUnmask);
        }
    }

    public void unmaskNonStructuringLinks(EditPartViewer viewer, GmModel gmModel, boolean unmaskNewNodes) {
        IElement elt = gmModel.getRepresentedIElement();
        if (elt != null) {
            GmAbstractDiagram diagram = (GmAbstractDiagram)viewer.getRootEditPart().getContents().getModel();
            Set unmaskedElements = unmaskNewNodes ? null : this.getUnmaskedElements(diagram);
            LinkPositionSet linkPositionSet = new LinkPositionSet(elt, false, unmaskedElements);
            Rectangle bounds = this.getBounds(viewer, gmModel);
            this.unmaskLinkPositionSet(viewer, linkPositionSet, bounds);
        }
    }

    public void unmaskNotes(EditPartViewer viewer, GmModel gmModel) {
        IElement elt = gmModel.getRepresentedIElement();
        if (elt != null && elt instanceof IModelElement) {
            ArrayList toUnmask = new ArrayList();
            IModelElement modelElement = (IModelElement)elt;
            toUnmask.addAll(modelElement.getDescriptor());
            toUnmask.addAll(modelElement.getDocument());
            Rectangle bounds = this.getBounds(viewer, gmModel);
            Point initialPosition = new Point(bounds.x - 200, bounds.y);
            ((ScalableFreeformRootEditPart2)viewer.getRootEditPart()).getFigure().translateToParent((Translatable)initialPosition);
            this.layoutVertical(initialPosition, viewer, toUnmask);
        }
    }

    public void unmaskParentLink(EditPartViewer viewer, GmModel gmModel) {
        IElement elt = gmModel.getRepresentedIElement();
        if (elt != null && elt instanceof INameSpace) {
            ArrayList<IGeneralization> toUnmask = new ArrayList<IGeneralization>();
            INameSpace ns = (INameSpace)elt;
            for (IGeneralization link : ns.getParent()) {
                toUnmask.add(link);
            }
            for (IGeneralization link : ns.getRealized()) {
                toUnmask.add(link);
            }
            Rectangle bounds = this.getBounds(viewer, gmModel);
            Point initialPosition = new Point(bounds.x + bounds.width / 2 - 200 * (toUnmask.size() - 1) / 2 - 100, bounds.y - 240);
            ((ScalableFreeformRootEditPart2)viewer.getRootEditPart()).getFigure().translateToParent((Translatable)initialPosition);
            this.layoutHorizontal(initialPosition, viewer, toUnmask);
        }
    }

    public void unmaskStructuringLinks(EditPartViewer viewer, GmModel gmModel, boolean unmaskNewNodes) {
        IElement elt = gmModel.getRepresentedIElement();
        if (elt != null) {
            GmAbstractDiagram diagram = (GmAbstractDiagram)viewer.getRootEditPart().getContents().getModel();
            Set unmaskedElements = unmaskNewNodes ? null : this.getUnmaskedElements(diagram);
            LinkPositionSet linkPositionSet = new LinkPositionSet(elt, true, unmaskedElements);
            Rectangle bounds = this.getBounds(viewer, gmModel);
            this.unmaskLinkPositionSet(viewer, linkPositionSet, bounds);
        }
    }

    private Rectangle getBounds(EditPartViewer viewer, GmModel gmModel) {
        GraphicalEditPart p = (GraphicalEditPart)viewer.getEditPartRegistry().get(gmModel);
        if (p.getFigure() instanceof HandleBounds) {
            return ((HandleBounds)p.getFigure()).getHandleBounds().getCopy();
        }
        return p.getFigure().getBounds().getCopy();
    }

    private Set<IElement> getUnmaskedElements(GmAbstractDiagram diagram) {
        HashSet<IElement> ret = new HashSet<IElement>();
        for (GmModel gm : diagram.getAllModels()) {
            IElement representedElement = gm.getRepresentedIElement();
            if (representedElement == null) continue;
            ret.add(representedElement);
        }
        return ret;
    }

    private Rectangle layoutHorizontal(Point initialPosition, EditPartViewer viewer, Collection<IElement> toUnmask) {
        Point unmaskPosition = new Point(initialPosition);
        for (IElement link : toUnmask) {
            this.unmask(viewer, link, unmaskPosition.x, unmaskPosition.y);
            unmaskPosition.x += 200;
        }
        return new Rectangle(initialPosition.x, initialPosition.y, 200 * toUnmask.size(), 120);
    }

    private Rectangle layoutVertical(Point initialPosition, EditPartViewer viewer, Collection<IElement> toUnmask) {
        Point unmaskPosition = new Point(initialPosition);
        for (IElement link : toUnmask) {
            this.unmask(viewer, link, unmaskPosition.x, unmaskPosition.y);
            unmaskPosition.y += 120;
        }
        return new Rectangle(initialPosition.x, initialPosition.y, 200, 120 * toUnmask.size());
    }

    private void unmask(EditPartViewer viewer, IElement element, int x, int y) {
        Command com;
        Point dropLocation = new Point(x, y);
        ModelElementDropRequest req = new ModelElementDropRequest();
        req.setDroppedElements(new IElement[]{element});
        req.setLocation(dropLocation);
        EditPart targetEditPart = viewer.findObjectAtExcluding(dropLocation, (Collection)Collections.EMPTY_LIST, (EditPartViewer.Conditional)new /* Unavailable Anonymous Inner Class!! */);
        targetEditPart = targetEditPart.getTargetEditPart((Request)req);
        if (targetEditPart != null && (com = targetEditPart.getCommand((Request)req)) != null && com.canExecute()) {
            targetEditPart.getViewer().getEditDomain().getCommandStack().execute(com);
        }
    }

    private void unmaskLinkPositionSet(EditPartViewer viewer, LinkPositionSet linkPositionSet, Rectangle bounds) {
        Point topInitialPosition = new Point(bounds.x + bounds.width / 2 - 200 * (linkPositionSet.getBottomLinks().size() - 1) / 2 - 100, bounds.y + bounds.height - 240);
        ((ScalableFreeformRootEditPart2)viewer.getRootEditPart()).getFigure().translateToParent((Translatable)topInitialPosition);
        Rectangle topBounds = this.layoutHorizontal(topInitialPosition, viewer, (Collection)linkPositionSet.getTopLinks());
        Point bottomInitialPosition = new Point(bounds.x + bounds.width / 2 - 200 * (linkPositionSet.getBottomLinks().size() - 1) / 2, bounds.y + bounds.height + 120);
        ((ScalableFreeformRootEditPart2)viewer.getRootEditPart()).getFigure().translateToParent((Translatable)bottomInitialPosition);
        Rectangle bottomBounds = this.layoutHorizontal(bottomInitialPosition, viewer, (Collection)linkPositionSet.getBottomLinks());
        Point rightInitialPosition = new Point(Math.max(topBounds.x + topBounds.width, bottomBounds.x + bottomBounds.width), bounds.y);
        ((ScalableFreeformRootEditPart2)viewer.getRootEditPart()).getFigure().translateToParent((Translatable)rightInitialPosition);
        this.layoutVertical(rightInitialPosition, viewer, (Collection)linkPositionSet.getRightLinks());
        Point leftInitialPosition = new Point(Math.min(topBounds.x, bottomBounds.x) - 200, bounds.y);
        ((ScalableFreeformRootEditPart2)viewer.getRootEditPart()).getFigure().translateToParent((Translatable)leftInitialPosition);
        this.layoutVertical(leftInitialPosition, viewer, (Collection)linkPositionSet.getLeftLinks());
    }
}

