/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.unmask;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.diagram.editor.handlers.unmask.AbstractUnmaskHandler;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalEditPart;

public class UnmaskParentLinksHandler
extends AbstractUnmaskHandler {
    public boolean isEnabled() {
        ArrayList secondaryEditParts = new ArrayList();
        GraphicalEditPart primaryEditPart = this.getSelection(secondaryEditParts);
        if (primaryEditPart == null) {
            return false;
        }
        GmModel primaryGm = (GmModel)primaryEditPart.getModel();
        IElement primaryElt = primaryGm.getRepresentedIElement();
        if (!(primaryElt instanceof INameSpace)) {
            return false;
        }
        for (GraphicalEditPart secondaryEditPart : secondaryEditParts) {
            GmModel secondaryGm = (GmModel)secondaryEditPart.getModel();
            IElement secondaryElt = secondaryGm.getRepresentedIElement();
            if (secondaryElt instanceof INameSpace) continue;
            return false;
        }
        return true;
    }

    protected void unmask(GraphicalEditPart primarySelection, List<GraphicalEditPart> secondarySelection) {
        ITransactionManager transactionManager = DiagramEditor.getInstance().getModelingSession().getTransactionManager();
        ITransaction t = transactionManager.createTransaction("UnmaskNonStructuringLinksAndNodes");
        try {
            try {
                GmModel primaryGm = (GmModel)primarySelection.getModel();
                unmaskManager.unmaskParentLink(primarySelection.getViewer(), primaryGm);
                for (GraphicalEditPart secondaryEditPart : secondarySelection) {
                    GmModel secondaryGm = (GmModel)primarySelection.getModel();
                    unmaskManager.unmaskParentLink(secondaryEditPart.getViewer(), secondaryGm);
                }
                transactionManager.commit(t);
                t = null;
            }
            catch (InvalidTransactionException e) {
                t = null;
                if (t != null) {
                    transactionManager.rollback(t);
                }
            }
        }
        finally {
            if (t != null) {
                transactionManager.rollback(t);
            }
        }
    }
}

