/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.zoom;

import com.modeliosoft.modelio.diagram.editor.AbstractDiagramEditor;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramFigure;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.ui.PlatformUI;

public class ZoomFitHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        AbstractDiagramEditor editor = (AbstractDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        int MARGIN = 30;
        ZoomManager zoomManager = (ZoomManager)editor.getAdapter(ZoomManager.class);
        Rectangle overallRect = this.computeOverallSize(editor.getRootEditPart());
        Dimension viewSize = ((FigureCanvas)editor.getRootEditPart().getViewer().getControl()).getViewport().getSize().getCopy();
        viewSize.shrink(30, 30);
        double zoomFactor = 1.0;
        double zoomFactorX = (double)overallRect.width / (double)viewSize.width;
        double zoomFactorY = (double)overallRect.height / (double)viewSize.height;
        zoomFactor = 1.0 / Math.max(zoomFactorX, zoomFactorY);
        if (zoomManager != null) {
            zoomManager.setZoom(zoomFactor);
        }
        FigureCanvas canvas = (FigureCanvas)editor.getRootEditPart().getViewer().getControl();
        Rectangle scaledRect = overallRect.scale(zoomFactor);
        int xPos = scaledRect.x + scaledRect.width / 2;
        int yPos = scaledRect.y + scaledRect.height / 2;
        canvas.getViewport().setViewLocation(xPos, yPos);
        return null;
    }

    private Rectangle computeOverallSize(RootEditPart rootEditPart) {
        Rectangle nodesRect;
        Rectangle overallRect = null;
        LayerManager lm = (LayerManager)rootEditPart;
        Layer printableLayers = (Layer)lm.getLayer((Object)"Printable Layers");
        ConnectionLayer connectionLayer = (ConnectionLayer)lm.getLayer((Object)"Connection Layer");
        AbstractDiagramFigure diagramFigure = this.getDiagramFigure(printableLayers);
        assert (diagramFigure != null);
        overallRect = nodesRect = this.computeMinimumBounds((Layer)diagramFigure);
        Rectangle linksRect = this.computeMinimumBounds((Layer)connectionLayer);
        overallRect.union(linksRect);
        return overallRect;
    }

    private AbstractDiagramFigure getDiagramFigure(Layer layer) {
        AbstractDiagramFigure result = null;
        for (Object o : layer.getChildren()) {
            AbstractDiagramFigure fig;
            if (o instanceof AbstractDiagramFigure) {
                return (AbstractDiagramFigure)o;
            }
            if (!(o instanceof Layer) || (fig = this.getDiagramFigure((Layer)o)) == null) continue;
            result = fig;
        }
        return result;
    }

    private Rectangle computeMinimumBounds(Layer layer) {
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Object o : layer.getChildren()) {
            Rectangle b = ((Figure)o).getBounds();
            if (b.x < xMin) {
                xMin = b.x;
            }
            if (b.x + b.width > xMax) {
                xMax = b.x + b.width;
            }
            if (b.y < yMin) {
                yMin = b.y;
            }
            if (b.y + b.height <= yMax) continue;
            yMax = b.y + b.height;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }
}

