/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.plugin;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.log.PluginLogger;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditorRegistry;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditorsManager;
import com.modeliosoft.modelio.diagram.editor.plugin.ToolRegistry;
import com.modeliosoft.modelio.ui.i18n.BundledMessages;
import java.util.ResourceBundle;

public class DiagramEditor {
    private static final DiagramEditor INSTANCE = new DiagramEditor();
    private IModelingSession modelingSession;
    private DiagramEditorRegistry editorsRegistry = null;
    private ToolRegistry toolRegistry = null;
    public static final String PLUGIN_ID = "org.modelio.diagram.editor";
    private DiagramEditorsManager editorsManager = new DiagramEditorsManager();
    public static PluginLogger LOG = new PluginLogger("org.modelio.diagram.editor");
    public static BundledMessages I18N = new BundledMessages("org.modelio.diagram.editor", ResourceBundle.getBundle("diagram-editor"));

    public static DiagramEditor getInstance() {
        return INSTANCE;
    }

    public IModelingSession getModelingSession() {
        return this.modelingSession;
    }

    public void sessionClosed(IModelingSession session) {
        this.toolRegistry = null;
        if (this.editorsRegistry != null) {
            this.editorsRegistry.closeAll();
        }
        this.editorsRegistry = null;
        if (this.editorsManager != null) {
            this.editorsManager.deactivate();
        }
        this.editorsManager = new DiagramEditorsManager();
        this.modelingSession = null;
    }

    public void sessionOpened(IModelingSession session) {
        this.modelingSession = session;
        this.editorsRegistry = new DiagramEditorRegistry();
        this.toolRegistry = new ToolRegistry(session);
        this.editorsManager.activate(session);
    }

    private DiagramEditor() {
    }

    public DiagramEditorRegistry getRegistry() {
        return this.editorsRegistry;
    }

    public ToolRegistry getToolRegistry() {
        return this.toolRegistry;
    }

    public DiagramEditorsManager getDiagramManager() {
        return this.editorsManager;
    }
}

