/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.plugin;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IActivationListener;
import com.modeliosoft.modelio.core.app.events.IActivationService;
import com.modeliosoft.modelio.diagram.editor.AbstractDiagramEditor;
import com.modeliosoft.modelio.diagram.editor.DiagramEditorInput;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditorRegistry;
import com.modeliosoft.modelio.diagram.editor.plugin.IDiagramConfigurer;
import com.modeliosoft.modelio.diagram.editor.plugin.PartListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DiagramEditorsManager
implements IActivationListener {
    private IModelingSession session;
    private Map<String, IDiagramConfigurer> configurers = new HashMap();

    void activate(IModelingSession modelingSession) {
        this.session = modelingSession;
        IActivationService activationService = O.getDefault().getActivationService();
        activationService.addActivationListener((IActivationListener)this);
    }

    void deactivate() {
        IActivationService activationService = O.getDefault().getActivationService();
        activationService.removeActivationListener((IActivationListener)this);
    }

    public void registerDiagramConfigurer(String metaclassName, String stereotype, IDiagramConfigurer configurer) {
        String key = metaclassName;
        if (stereotype != null) {
            key = String.valueOf(key) + stereotype;
        }
        this.configurers.put(key, configurer);
    }

    public void unregisterDiagramConfigurer(String metaclassName, String stereotype, IDiagramConfigurer configurer) {
        DiagramEditorRegistry registry;
        String key = metaclassName;
        if (stereotype != null) {
            key = String.valueOf(key) + stereotype;
        }
        if (configurer.equals(this.configurers.get(key))) {
            this.configurers.remove(key);
        }
        if ((registry = DiagramEditor.getInstance().getRegistry()) != null) {
            for (IAbstractDiagram diagram : new ArrayList(registry.getAllDiagrams())) {
                if (!metaclassName.equals(diagram.getMetaclassName()) || !diagram.isStereotyped(stereotype)) continue;
                AbstractDiagramEditor editor = registry.get(diagram);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) continue;
                window.getActivePage().closeEditor((IEditorPart)editor, false);
            }
        }
    }

    public final boolean activateElement(IElement target) {
        IEditorPart openedEditor;
        DiagramEditorInput editorInput;
        ArrayList<IDiagramConfigurer> stereotypeConfigurers;
        IDiagramConfigurer basicConfigurer;
        IAbstractDiagram diagram;
        block13: {
            IWorkbenchPage workbenchPage;
            block12: {
                block11: {
                    if (!(target instanceof IAbstractDiagram)) {
                        return false;
                    }
                    diagram = (IAbstractDiagram)target;
                    String key = diagram.getMetaclassName();
                    basicConfigurer = (IDiagramConfigurer)this.configurers.get(key);
                    stereotypeConfigurers = new ArrayList<IDiagramConfigurer>();
                    for (IStereotype stereo : diagram.getExtension()) {
                        IDiagramConfigurer stereotypeConfigurer = (IDiagramConfigurer)this.configurers.get(String.valueOf(key) + stereo.getName());
                        if (stereotypeConfigurer == null) continue;
                        stereotypeConfigurers.add(stereotypeConfigurer);
                    }
                    if (basicConfigurer == null) {
                        DiagramEditor.LOG.error("Unsupported diagram type:" + key);
                        return false;
                    }
                    workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    DiagramEditorInput diagramEditorInput = editorInput = stereotypeConfigurers.size() > 0 ? ((IDiagramConfigurer)stereotypeConfigurers.get(0)).createDiagramEditorInput(this.session, diagram) : basicConfigurer.createDiagramEditorInput(this.session, diagram);
                    if (editorInput.getGmDiagram() != null) break block11;
                    editorInput.dispose();
                    return false;
                }
                IEditorPart editorPart = workbenchPage.findEditor((IEditorInput)editorInput);
                if (editorPart == null) break block12;
                workbenchPage.activate((IWorkbenchPart)editorPart);
                editorInput.dispose();
                return true;
            }
            openedEditor = workbenchPage.openEditor((IEditorInput)editorInput, basicConfigurer.getDiagramEditorID());
            if (openedEditor instanceof AbstractDiagramEditor) break block13;
            return false;
        }
        try {
            AbstractDiagramEditor editor = (AbstractDiagramEditor)openedEditor;
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener2)new PartListener(editor, editorInput, diagram));
            try {
                DiagramEditor.getInstance().getRegistry().put(diagram, editor);
            }
            catch (Exception e) {
                DiagramEditor.LOG.error("Editor already found for this diagram: " + diagram.getName() + "\n" + e.getStackTrace());
            }
            editor.setPaletteRoot(basicConfigurer.initPalette(editor, DiagramEditor.getInstance().getToolRegistry()));
            for (IDiagramConfigurer stereotypeConfigurer : stereotypeConfigurers) {
                editor.setPaletteRoot(stereotypeConfigurer.initPalette(editor, DiagramEditor.getInstance().getToolRegistry()));
            }
            return true;
        }
        catch (PartInitException e) {
            DiagramEditor.LOG.error("Unexpected error while trying to activate diagram: " + diagram.getName() + "\n" + e.getLocalizedMessage() + "\n" + e.getStackTrace());
            return false;
        }
    }

    public IDiagramConfigurer getDefaultDiagramConfigurer(String metaclassName) {
        return (IDiagramConfigurer)this.configurers.get(metaclassName);
    }
}

