/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.popup.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.diagram.editor.ScalableFreeformRootEditPart2;
import com.modeliosoft.modelio.diagram.editor.popup.handlers.AbstractCreateHandler;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDiagramCreateHandler
extends AbstractCreateHandler {
    private CreateRequest targetRequest;

    public boolean isToFilter(Map<String, String> context) {
        this.metaclass = context.get("metaclass");
        this.dependency = context.get("dependency");
        this.stereotype = context.get("stereotype");
        return this.shouldEnable();
    }

    protected IElement create(IElement selectedElement, IModelingSession modelingSession) throws ExecutionException {
        EditPart selectedEditPart = this.getSelectedEditPart();
        if (selectedEditPart != null) {
            Command command;
            try {
                this.updateTargetRequest();
            }
            catch (IllegalArgumentException e) {
                throw new ExecutionException("Cannot create element.", (Throwable)e);
            }
            catch (StereotypeNotFoundException e) {
                throw new ExecutionException("Cannot create element: " + e.getLocalizedMessage(), (Throwable)e);
            }
            CreateRequest createRequest = this.getTargetRequest();
            EditPart targetEditPart = this.findTargetEditPart(selectedEditPart);
            if (targetEditPart != null && (command = targetEditPart.getCommand((Request)createRequest)) != null && command.canExecute()) {
                targetEditPart.getViewer().getEditDomain().getCommandStack().execute(command);
            }
        }
        this.targetRequest = null;
        return null;
    }

    protected CreateRequest createTargetRequest() {
        CreateRequest createRequest = new CreateRequest();
        createRequest.setSize(new Dimension(-1, -1));
        return createRequest;
    }

    protected EditPart findTargetEditPart(EditPart fromEditPart) {
        EditPart target = fromEditPart.getTargetEditPart((Request)this.getTargetRequest());
        if (target != null) {
            if (this.relateSelectedElement(target)) {
                return target;
            }
            return null;
        }
        for (Object child : fromEditPart.getChildren()) {
            target = this.findTargetEditPart((EditPart)child);
            if (target == null || !this.relateSelectedElement(target)) continue;
            return target;
        }
        return null;
    }

    protected EditPart getSelectedEditPart() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IAdaptable) {
            IAdaptable adapter = (IAdaptable)((IStructuredSelection)selection).getFirstElement();
            return (EditPart)adapter.getAdapter(EditPart.class);
        }
        return null;
    }

    protected CreateRequest getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected void postCommit(IElement element) {
    }

    protected void updateTargetRequest() throws IllegalArgumentException, StereotypeNotFoundException {
        EditPart selectedEditPart = this.getSelectedEditPart();
        if (selectedEditPart != null) {
            Point creationLocation;
            this.targetRequest = null;
            CreateRequest createRequest = this.getTargetRequest();
            if (selectedEditPart instanceof GraphicalEditPart) {
                IFigure figure = ((GraphicalEditPart)selectedEditPart).getFigure();
                Rectangle bounds = figure instanceof HandleBounds ? ((HandleBounds)figure).getHandleBounds() : figure.getBounds();
                Point creationLocationTip = ((ScalableFreeformRootEditPart2)selectedEditPart.getRoot()).getCreationLocationTip();
                Point.SINGLETON.setLocation(creationLocationTip);
                figure.translateToRelative((Translatable)Point.SINGLETON);
                if (figure.containsPoint(Point.SINGLETON)) {
                    creationLocation = creationLocationTip;
                } else {
                    Point.SINGLETON.setLocation(bounds.getCenter());
                    figure.translateToAbsolute((Translatable)Point.SINGLETON);
                    creationLocation = Point.SINGLETON.getCopy();
                }
            } else {
                ScalableFreeformRootEditPart2 root = (ScalableFreeformRootEditPart2)selectedEditPart.getRoot();
                creationLocation = root.getCreationLocationTip();
            }
            createRequest.setLocation(creationLocation);
            IStereotype iStereotype = null;
            if (this.stereotype != null) {
                iStereotype = this.getModelingSession().getModel().getMetamodelExtensions().getStereotype(MetaModelExpert.getMetaclass((String)this.metaclass), this.stereotype);
            }
            createRequest.setFactory((CreationFactory)new ModelioCreationContext(this.metaclass, this.dependency, iStereotype));
        } else {
            this.targetRequest = null;
        }
    }

    private boolean relateSelectedElement(EditPart a) {
        IElement el = ((GmModel)a.getModel()).getRelatedIElement();
        return el != null && el.equals((Object)this.getSelectedElement());
    }

    private boolean shouldEnable() {
        EditPart selectedEditPart = this.getSelectedEditPart();
        if (selectedEditPart != null) {
            try {
                this.updateTargetRequest();
                CreateRequest r = this.getTargetRequest();
                EditPart targetEditPart = this.findTargetEditPart(selectedEditPart);
                if (targetEditPart != null) {
                    Command command = targetEditPart.getCommand((Request)r);
                    return command != null && command.canExecute();
                }
            }
            catch (IllegalArgumentException e) {
                return true;
            }
            catch (StereotypeNotFoundException e) {
                return true;
            }
        }
        return false;
    }
}

