/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.popup.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.transmuter.ITransmuter;
import com.modeliosoft.modelio.core.model.transmuter.TransmuterRegistry;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class TransmuteElementHandler
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        boolean singleSelection = false;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            singleSelection = ((IStructuredSelection)selection).size() == 1;
        }
        this.setBaseEnabled(singleSelection && this.getSelectedElement().getElementStatus().isModifiable());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITransaction transaction;
        ITransactionManager transactionManager;
        IElement element;
        String metaclass;
        block16: {
            metaclass = event.getParameter("metaclass");
            element = this.getSelectedElement();
            IModelingSession modellingSession = DiagramEditor.getInstance().getModelingSession();
            transactionManager = modellingSession.getTransactionManager();
            transaction = transactionManager.createTransaction("Transmute to " + metaclass);
            try {
                try {
                    if (TransmuterRegistry.getInstance().canTransmute(element.getMetaclassName(), metaclass)) {
                        ITransmuter transmuter = TransmuterRegistry.getInstance().getTransmuter(element, metaclass);
                        IElement result = transmuter.Transmute();
                        GmModel model = (GmModel)this.getSelectedEditPart().getModel();
                        model.getDiagram().unmask((GmCompositeNode)model.getParent(), result, model.getLayoutData());
                        transactionManager.commit(transaction);
                        transaction = null;
                    }
                }
                catch (InvalidTransactionException exception) {
                    transaction = null;
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
                throw throwable;
            }
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
        transaction = transactionManager.createTransaction("Delete " + metaclass);
        try {
            try {
                element.delete();
                transactionManager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException exception) {
                transaction = null;
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
        return null;
    }

    protected IElement getSelectedElement() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IAdaptable) {
            IAdaptable adapter = (IAdaptable)((IStructuredSelection)selection).getFirstElement();
            return (IElement)adapter.getAdapter(IElement.class);
        }
        return null;
    }

    protected EditPart getSelectedEditPart() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IAdaptable) {
            IAdaptable adapter = (IAdaptable)((IStructuredSelection)selection).getFirstElement();
            return (EditPart)adapter.getAdapter(EditPart.class);
        }
        return null;
    }
}

