/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.silent;

import com.modeliosoft.modelio.core.IModelingSession;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;

class DiagramCommandStack
extends CommandStack {
    private IModelingSession session;

    public DiagramCommandStack(IModelingSession session) {
        this.session = session;
    }

    public boolean canRedo() {
        return this.session.getUndoManager().hasRedo();
    }

    public boolean canUndo() {
        return this.session.getUndoManager().hasUndo();
    }

    public void undo() {
        Command command = null;
        this.notifyListeners(command, 4);
        try {
            this.session.getUndoManager().undo();
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 32);
        }
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = null;
        this.notifyListeners(command, 2);
        try {
            this.session.getUndoManager().redo();
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 16);
        }
    }

    public int getUndoLimit() {
        return -1;
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    public boolean isDirty() {
        return this.session.isDirty();
    }

    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.notifyListeners(command, 1);
        try {
            try {
                command.execute();
                this.notifyListeners();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.notifyListeners(command, 8);
        }
    }

    public void markSaveLocation() {
    }
}

