/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.silent;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.diagram.editor.DiagramEditorInput;
import com.modeliosoft.modelio.diagram.editor.IDiagramEditor;
import com.modeliosoft.modelio.diagram.editor.ScalableFreeformRootEditPart2;
import com.modeliosoft.modelio.diagram.editor.silent.DiagramCommandStack;
import com.modeliosoft.modelio.diagram.editor.silent.NoControlGraphicalViewer;
import com.modeliosoft.modelio.diagram.editor.tools.PanSelectionTool;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.OrthogonalRouter;
import com.modeliosoft.modelio.diagram.elements.core.link.ConnectionRouterRegistry;
import com.modeliosoft.modelio.diagram.elements.editpartFactory.ModelioEditPartFactory;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.ui.IEditorInput;

public class SilentDiagramEditor
implements IDiagramEditor {
    private final RootEditPart rootEditPart = new ScalableFreeformRootEditPart2();
    private EditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private IEditorInput editorInput = null;

    public SilentDiagramEditor(IEditorInput input) {
        this.setEditDomain(new EditDomain());
        this.editorInput = input;
        this.createGraphicalViewer();
    }

    private void configureGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setRootEditPart(this.rootEditPart);
        viewer.setEditPartFactory(this.getEditPartFactory());
        PanSelectionTool selectionTool = new PanSelectionTool();
        this.getEditDomain().setActiveTool((Tool)selectionTool);
        this.getEditDomain().setDefaultTool((Tool)selectionTool);
        viewer.setEditDomain(this.getEditDomain());
        IModelingSession modelingSession = O.getDefault().getModelingSession();
        if (modelingSession != null) {
            this.getEditDomain().setCommandStack((CommandStack)new DiagramCommandStack(modelingSession));
        }
    }

    private void initializeConnectionRouters(ConnectionRouterRegistry routersRegistry) {
        routersRegistry.put((Object)StyleKey.ConnectionRouterId.DIRECT, (Object)ConnectionRouter.NULL);
        routersRegistry.put((Object)StyleKey.ConnectionRouterId.BENDPOINT, (Object)new BendpointConnectionRouter());
        routersRegistry.put((Object)StyleKey.ConnectionRouterId.ORTHOGONAL, (Object)new OrthogonalRouter());
    }

    private void createGraphicalViewer() {
        NoControlGraphicalViewer viewer = new NoControlGraphicalViewer();
        viewer.createControl(null);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public void disposeHandle() {
        DiagramEditorInput input = (DiagramEditorInput)this.getEditorInput();
        if (input != null) {
            input.dispose();
        }
        this.getEditDomain().setActiveTool(null);
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, type);
    }

    private CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    private EditDomain getEditDomain() {
        return this.editDomain;
    }

    private GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    private void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        ConnectionRouterRegistry routersRegistry = new ConnectionRouterRegistry();
        viewer.setProperty("ConnectionRouterRegistry", (Object)routersRegistry);
        this.initializeConnectionRouters(routersRegistry);
        GmAbstractDiagram gmDiagram = ((DiagramEditorInput)this.getEditorInput()).getGmDiagram();
        viewer.setContents((Object)gmDiagram);
        gmDiagram.refreshAllFromObModel();
    }

    public RootEditPart getRootEditPart() {
        return this.rootEditPart;
    }

    private EditPartFactory getEditPartFactory() {
        return ModelioEditPartFactory.getInstance();
    }

    private void setEditDomain(EditDomain ed) {
        this.editDomain = ed;
    }

    private void setGraphicalViewer(GraphicalViewer viewer) {
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        this.graphicalViewer = viewer;
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }
}

