/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.silent;

import com.modeliosoft.modelio.diagram.editor.silent.SynchronousUpdateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

final class SynchronousUpdateManager
extends UpdateManager {
    private Rectangle damage;
    private Map<IFigure, Rectangle> dirtyRegions = new HashMap();
    private GraphicsSource graphicsSource;
    private List<IFigure> invalidFigures = new ArrayList();
    private IFigure root;
    private boolean updateQueued;
    private boolean updating;
    private boolean validating;
    private RunnableChain afterUpdate;

    public synchronized void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
        this.queueWork();
        if (w == 0 || h == 0 || !figure.isShowing()) {
            return;
        }
        Rectangle rect = (Rectangle)this.dirtyRegions.get(figure);
        if (rect == null) {
            rect = new Rectangle(x, y, w, h);
            this.dirtyRegions.put(figure, rect);
        } else {
            rect.union(x, y, w, h);
        }
    }

    public synchronized void addInvalidFigure(IFigure f) {
        this.queueWork();
        if (this.invalidFigures.contains(f)) {
            return;
        }
        this.invalidFigures.add(f);
    }

    protected Graphics getGraphics(Rectangle region) {
        if (this.graphicsSource == null) {
            return null;
        }
        return this.graphicsSource.getGraphics(region);
    }

    public synchronized void performUpdate() {
        if (this.isDisposed() || this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.performValidation();
            this.updateQueued = false;
            this.repairDamage();
            if (this.afterUpdate != null) {
                RunnableChain chain = this.afterUpdate;
                this.afterUpdate = null;
                chain.run();
                if (this.afterUpdate != null) {
                    this.queueWork();
                }
            }
        }
        finally {
            this.updating = false;
        }
    }

    public synchronized void performValidation() {
        if (this.invalidFigures.isEmpty() || this.validating) {
            return;
        }
        try {
            this.validating = true;
            this.fireValidating();
            int i = 0;
            while (i < this.invalidFigures.size()) {
                IFigure fig = (IFigure)this.invalidFigures.get(i);
                this.invalidFigures.set(i, null);
                fig.validate();
                ++i;
            }
        }
        finally {
            this.invalidFigures.clear();
            this.validating = false;
        }
    }

    public synchronized void performUpdate(Rectangle exposed) {
        this.addDirtyRegion(this.root, exposed);
        this.performUpdate();
    }

    protected void queueWork() {
        if (!this.updateQueued) {
            this.updateQueued = true;
            this.sendUpdateRequest();
        }
    }

    protected void sendUpdateRequest() {
        Display display = Display.getCurrent();
        if (display == null) {
            throw new SWTException(22);
        }
        display.syncExec((Runnable)new UpdateRequest(this));
    }

    protected void releaseGraphics(Graphics graphics) {
        graphics.dispose();
        this.graphicsSource.flushGraphics(this.damage);
    }

    protected void repairDamage() {
        Graphics graphics;
        for (IFigure figure : this.dirtyRegions.keySet()) {
            IFigure walker = figure.getParent();
            Rectangle contribution = (Rectangle)this.dirtyRegions.get(figure);
            contribution.intersect(figure.getBounds());
            while (!contribution.isEmpty() && walker != null) {
                walker.translateToParent((Translatable)contribution);
                contribution.intersect(walker.getBounds());
                walker = walker.getParent();
            }
            if (this.damage == null) {
                this.damage = new Rectangle(contribution);
                continue;
            }
            this.damage.union(contribution);
        }
        if (!this.dirtyRegions.isEmpty()) {
            Map oldRegions = this.dirtyRegions;
            this.dirtyRegions = new HashMap();
            this.firePainting(this.damage, oldRegions);
        }
        if (this.damage != null && !this.damage.isEmpty() && (graphics = this.getGraphics(this.damage)) != null) {
            this.root.paint(graphics);
            this.releaseGraphics(graphics);
        }
        this.damage = null;
    }

    public synchronized void runWithUpdate(Runnable runnable) {
        this.afterUpdate = new RunnableChain(this, runnable, this.afterUpdate);
        if (!this.updating) {
            this.queueWork();
        }
    }

    public void setGraphicsSource(GraphicsSource gs) {
        this.graphicsSource = gs;
    }

    public void setRoot(IFigure figure) {
        this.root = figure;
    }

    protected void validateFigures() {
        this.performValidation();
    }
}

