/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.tools;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.diagram.editor.tools.PanSelectionTool;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramPersistence;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.ui.gef.SharedCursors2;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;

public class ClonePropertiesSelectionTool
extends PanSelectionTool {
    private GraphicalEditPart refEditPart = null;
    private boolean fullMode = true;
    private static MetaKey[] graphicProperties = new MetaKey[]{MetaKey.FILLCOLOR, MetaKey.FILLMODE, MetaKey.FONT, MetaKey.LINECOLOR, MetaKey.LINEPATTERN, MetaKey.LINEWIDTH, MetaKey.LINERADIUS, MetaKey.TEXTCOLOR};

    public ClonePropertiesSelectionTool(GraphicalEditPart refEditPart) {
        this.refEditPart = refEditPart;
    }

    protected Cursor calculateCursor() {
        if (this.getHovered() == null) {
            return Cursors.NO;
        }
        return this.fullMode ? SharedCursors2.CURSOR_CLONE_ALL_OPTIONS : SharedCursors2.CURSOR_CLONE_GRAPHIC_OPTIONS;
    }

    protected boolean handleButtonDown(int which) {
        super.handleButtonDown(which);
        List selectedEditParts = this.getCurrentViewer().getSelectedEditParts();
        if (selectedEditParts == null || selectedEditParts.isEmpty()) {
            return true;
        }
        GraphicalEditPart target = (GraphicalEditPart)selectedEditParts.get(0);
        if (target == null) {
            return false;
        }
        if (target.equals(this.refEditPart)) {
            return false;
        }
        IModelingSession session = ((IGmObject)target.getModel()).getDiagram().getModelManager().getModelingSession();
        ITransactionManager transactionManager = session.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Clone properties");
        try {
            try {
                if (this.fullMode) {
                    this.cloneAllProperties(target);
                } else {
                    this.cloneGraphicProperties(target);
                }
                DiagramPersistence.saveDiagram((GmAbstractDiagram)((IGmObject)target.getModel()).getDiagram());
                transactionManager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
        return true;
    }

    private void cloneGraphicProperties(GraphicalEditPart target) {
        IGmObject refGm = (IGmObject)this.refEditPart.getModel();
        IStyle refStyle = refGm.getStyle();
        IGmObject targetGm = (IGmObject)target.getModel();
        IStyle targetStyle = targetGm.getStyle();
        targetStyle.setCascadedStyle(refStyle.getCascadedStyle());
        MetaKey[] metaKeyArray = graphicProperties;
        int n = graphicProperties.length;
        int n2 = 0;
        while (n2 < n) {
            MetaKey mk = metaKeyArray[n2];
            if (refGm.getStyleKey(mk) != null && targetGm.getStyleKey(mk) != null) {
                targetStyle.setProperty(targetGm.getStyleKey(mk), refStyle.getProperty(refGm.getStyleKey(mk)));
            }
            ++n2;
        }
        targetStyle.normalize();
    }

    private void cloneAllProperties(GraphicalEditPart target) {
        IGmObject refGm = (IGmObject)this.refEditPart.getModel();
        IStyle refStyle = refGm.getStyle();
        IGmObject targetGm = (IGmObject)target.getModel();
        IStyle targetStyle = targetGm.getStyle();
        targetStyle.setCascadedStyle(refStyle.getCascadedStyle());
        for (StyleKey sk : refGm.getStyleKeys()) {
            if (targetGm.getStyleKeys().contains(sk)) {
                targetStyle.setProperty(sk, refStyle.getProperty(sk));
                continue;
            }
            MetaKey mk = sk.getMetakey();
            if (mk == null || targetGm.getStyleKey(mk) == null) continue;
            targetStyle.setProperty(targetGm.getStyleKey(mk), refStyle.getProperty(sk));
        }
        targetStyle.normalize();
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (e.keyCode == 262144) {
            this.fullMode = false;
            this.refreshCursor();
        }
        if (e.keyCode == 27 || e.keyCode == 32) {
            this.getDomain().setActiveTool(this.getDomain().getDefaultTool());
        }
        return super.handleKeyDown(e);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (e.keyCode == 262144) {
            this.fullMode = true;
            this.refreshCursor();
        }
        if (e.keyCode == 27 || e.keyCode == 32) {
            this.abort();
        }
        return super.handleKeyDown(e);
    }

    protected boolean handleMove() {
        this.setCursor(this.calculateCursor());
        return super.handleMove();
    }

    private GraphicalEditPart getHovered() {
        GraphicalEditPart ep = (GraphicalEditPart)this.getTargetEditPart();
        return ep instanceof RootEditPart ? null : ep;
    }

    protected boolean handleFocusLost() {
        this.abort();
        return super.handleFocusLost();
    }

    private void abort() {
        this.getDomain().setActiveTool(this.getDomain().getDefaultTool());
    }

    protected boolean handleViewerExited() {
        this.abort();
        return super.handleViewerExited();
    }

    public void mouseDown(MouseEvent e, EditPartViewer viewer) {
        super.mouseDown(e, viewer);
        super.mouseUp(e, viewer);
        super.mouseDown(e, viewer);
    }
}

