/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.tools;

import com.modeliosoft.modelio.diagram.editor.ScalableFreeformRootEditPart2;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramFigure;
import com.modeliosoft.modelio.ui.gef.SharedCursors2;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.swt.graphics.Cursor;

public class PanSelectionTool
extends SelectionTool {
    private Point viewLocation;
    protected static final int PAN = 128;
    protected static final int PAN_IN_PROGRESS = 256;
    protected static final int MAX_STATE = 256;
    private static final int DRAG_BUTTON = 2;
    private static final int DRAG_THRESHOLD = 2;
    protected static final int WORKAREA_RESIZE_INCREMENT = 40;
    private static final int RIGHT_BUTTON = 3;

    protected String getDebugName() {
        return "Panning Tool";
    }

    protected String getDebugNameForState(int state) {
        if (state == 128) {
            return "Pan Initial";
        }
        if (state == 256) {
            return "Pan In Progress";
        }
        return super.getDebugNameForState(state);
    }

    protected Cursor getDefaultCursor() {
        if (this.isInState(256)) {
            return SharedCursors2.CURSOR_GRAB_HAND;
        }
        return super.getDefaultCursor();
    }

    protected boolean handleButtonDown(int which) {
        if (which == 2 && this.getCurrentViewer().getControl() instanceof FigureCanvas && this.stateTransition(1, 128)) {
            this.viewLocation = ((FigureCanvas)this.getCurrentViewer().getControl()).getViewport().getViewLocation();
            this.refreshCursor();
            return true;
        }
        return super.handleButtonDown(which);
    }

    protected boolean handleButtonUp(int which) {
        if (which == 2 && this.stateTransition(256, 1)) {
            this.refreshCursor();
            return true;
        }
        if (which == 3) {
            ScalableFreeformRootEditPart2 rootEditPart = (ScalableFreeformRootEditPart2)this.getCurrentViewer().getRootEditPart();
            rootEditPart.setCreationLocationTip(this.getLocation());
        }
        return super.handleButtonUp(which);
    }

    protected boolean handleDrag() {
        if (this.isInState(128) && this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            if ((Math.abs(this.getDragMoveDelta().width) > 2 || Math.abs(this.getDragMoveDelta().height) > 2) && this.stateTransition(128, 256)) {
                this.refreshCursor();
                return true;
            }
            return super.handleDrag();
        }
        if (this.isInState(256) && this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            GraphicalViewer v = (GraphicalViewer)this.getCurrentViewer();
            ScalableFreeformRootEditPart2 rootEditPart = (ScalableFreeformRootEditPart2)v.getRootEditPart();
            AbstractDiagramFigure diagramFigure = (AbstractDiagramFigure)((GraphicalEditPart)rootEditPart.getContents()).getFigure();
            FigureCanvas canvas = (FigureCanvas)this.getCurrentViewer().getControl();
            this.adjustWorkarea(diagramFigure, canvas);
            canvas.scrollTo(this.viewLocation.x - this.getDragMoveDelta().width, this.viewLocation.y - this.getDragMoveDelta().height);
            this.viewLocation = canvas.getViewport().getViewLocation();
            this.setStartLocation(this.getLocation());
            return true;
        }
        return super.handleDrag();
    }

    protected boolean handleFocusLost() {
        if (this.isInState(384)) {
            this.setState(1);
            this.refreshCursor();
            return true;
        }
        return super.handleFocusLost();
    }

    private void adjustWorkarea(AbstractDiagramFigure diagramFigure, FigureCanvas canvas) {
        Rectangle r = diagramFigure.getFreeformExtent().getCopy();
        int newX = this.viewLocation.x - this.getDragMoveDelta().width;
        RangeModel hRange = canvas.getViewport().getHorizontalRangeModel();
        if (newX < hRange.getMinimum()) {
            r.x -= 40;
            r.width += 40;
        } else if (newX + hRange.getExtent() > hRange.getMaximum()) {
            r.width += 40;
        }
        int newY = this.viewLocation.y - this.getDragMoveDelta().height;
        RangeModel vRange = canvas.getViewport().getVerticalRangeModel();
        if (newY < vRange.getMinimum()) {
            r.y -= 40;
            r.height += 40;
        } else if (newY + vRange.getExtent() > vRange.getMaximum()) {
            r.height += 40;
        }
        diagramFigure.setWorkArea(r);
    }
}

