/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.diagrams;

import com.modeliosoft.modelio.api.diagram.IDiagramGraphic;
import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.dg.IDiagramDG;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramHandle;
import com.modeliosoft.modelio.api.impl.diagrams.dg.DGFactory;
import com.modeliosoft.modelio.api.impl.diagrams.dg.common.DiagramDG;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.diagram.editor.AbstractDiagramEditor;
import com.modeliosoft.modelio.diagram.editor.DiagramCommandStack;
import com.modeliosoft.modelio.diagram.editor.DiagramEditorInput;
import com.modeliosoft.modelio.diagram.editor.IDiagramEditor;
import com.modeliosoft.modelio.diagram.editor.ScalableFreeformRootEditPart2;
import com.modeliosoft.modelio.diagram.editor.handlers.ImageBuilder;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.editor.plugin.IDiagramConfigurer;
import com.modeliosoft.modelio.diagram.editor.silent.SilentDiagramEditor;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramPersistence;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.IEditorInput;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiagramHandle
implements IDiagramHandle {
    private DiagramEditorInput diagramEditorInput;
    private IDiagramEditor editor;

    private DiagramHandle(IDiagramEditor editor, DiagramEditorInput diagramEditorInput) {
        this.editor = editor;
        this.diagramEditorInput = diagramEditorInput;
    }

    public static DiagramHandle create(IAbstractDiagram abstractDiagram) {
        AbstractDiagramEditor alreadyExistingEditor = DiagramEditor.getInstance().getRegistry().get(abstractDiagram);
        if (alreadyExistingEditor != null && ((DiagramEditorInput)alreadyExistingEditor.getEditorInput()).getGmDiagram().isVisible()) {
            return DiagramHandle.create((IDiagramEditor)alreadyExistingEditor);
        }
        IDiagramConfigurer configurer = DiagramEditor.getInstance().getDiagramManager().getDefaultDiagramConfigurer(abstractDiagram.getMetaclassName());
        DiagramEditorInput input = configurer.createDiagramEditorInput(O.getDefault().getModelingSession(), abstractDiagram);
        SilentDiagramEditor editor = new SilentDiagramEditor((IEditorInput)input);
        return DiagramHandle.create((IDiagramEditor)editor);
    }

    public IAbstractDiagram getDiagram() {
        return this.getDiagramEditorInput().getDiagram();
    }

    public List<IDiagramGraphic> getDiagramGraphics(IElement element) {
        return DGFactory.getInstance().getDiagramGraphics(this, this.getDiagramGraphicModels(element));
    }

    public IDiagramDG getDiagramNode() {
        DiagramDG diagramDG = (DiagramDG)DGFactory.getInstance().getDiagramNode(this, (GmNodeModel)this.getDiagramEditorInput().getGmDiagram());
        return diagramDG;
    }

    public GraphicalEditPart getEditPart(IGmObject gmObject) {
        GraphicalViewer viewer = (GraphicalViewer)this.editor.getAdapter(GraphicalViewer.class);
        return (GraphicalEditPart)viewer.getEditPartRegistry().get(gmObject);
    }

    public void mask(IDiagramGraphic graphic) {
        graphic.mask();
    }

    public void save() {
        DiagramPersistence.saveDiagram((GmAbstractDiagram)this.getDiagramEditorInput().getGmDiagram());
    }

    public List<IDiagramGraphic> unmask(IElement element, int x, int y) {
        Command com;
        List existingGraphics = this.getDiagramGraphics(element);
        List existingGMs = this.getDiagramGraphicModels(element);
        GraphicalEditPart diagramEditPart = this.getEditPart((IGmObject)this.getDiagramEditorInput().getGmDiagram());
        GraphicalViewer viewer = (GraphicalViewer)diagramEditPart.getViewer();
        Point dropLocation = new Point(x, y);
        ((ScalableFreeformRootEditPart2)diagramEditPart.getViewer().getRootEditPart()).getFigure().translateToParent((Translatable)dropLocation);
        ModelElementDropRequest req = new ModelElementDropRequest();
        req.setDroppedElements(new IElement[]{element});
        req.setLocation(dropLocation);
        req.isSmart(false);
        EditPart targetEditPart = viewer.findObjectAtExcluding(dropLocation, (Collection)Collections.EMPTY_LIST, (EditPartViewer.Conditional)new Conditional(this, req));
        targetEditPart = targetEditPart.getTargetEditPart((Request)req);
        if (targetEditPart != null && (com = targetEditPart.getCommand((Request)req)) != null && com.canExecute()) {
            targetEditPart.getViewer().getEditDomain().getCommandStack().execute(com);
            List allGraphics = this.getDiagramGraphics(element);
            ArrayList<IDiagramGraphic> results = new ArrayList<IDiagramGraphic>();
            for (IDiagramGraphic dg : allGraphics) {
                if (existingGraphics.contains(dg)) continue;
                results.add(dg);
            }
            List allGMs = this.getDiagramGraphicModels(element);
            for (GmModel dg : allGMs) {
                GraphicalEditPart newEP;
                if (existingGMs.contains(dg) || (newEP = this.getEditPart((IGmObject)dg)) == null) continue;
                newEP.getFigure().getUpdateManager().performValidation();
            }
            return results;
        }
        return null;
    }

    @Deprecated
    public void saveInFile(String format, String targetFile) {
        this.saveInFile(format, targetFile, 10);
    }

    private void saveAsImage(RootEditPart rootEditPart, String location, int format, int margin) {
        ImageBuilder imageBuilder = new ImageBuilder();
        Image img = imageBuilder.makeImage(rootEditPart, format, margin);
        if (img != null) {
            ImageLoader imgLoader = new ImageLoader();
            imgLoader.data = new ImageData[]{img.getImageData()};
            imgLoader.save(location, format);
            img.dispose();
        }
    }

    public void close() {
        this.setBatchMode(false);
        this.editor.disposeHandle();
        this.diagramEditorInput = null;
    }

    private List<GmModel> getDiagramGraphicModels(IElement element) {
        ArrayList<GmModel> ret = new ArrayList<GmModel>();
        for (GmModel gm : this.getDiagramEditorInput().getGmDiagram().getAllGMRepresenting(new ObRef(element))) {
            if (gm instanceof GmNodeModel && !((GmNodeModel)gm).isVisible()) continue;
            ret.add(gm);
        }
        return ret;
    }

    public void saveInFile(String format, String targetFile, int margin) {
        int intFormat = format.equalsIgnoreCase("PNG") ? 5 : (format.equalsIgnoreCase("BMP") ? 0 : (format.equalsIgnoreCase("JPEG") ? 4 : (format.equalsIgnoreCase("GIF") ? 2 : 5)));
        this.saveAsImage(this.editor.getRootEditPart(), targetFile, intFormat, margin);
    }

    public static DiagramHandle create(IDiagramEditor editor) {
        return new DiagramHandle(editor, (DiagramEditorInput)editor.getEditorInput());
    }

    private DiagramEditorInput getDiagramEditorInput() {
        if (this.diagramEditorInput == null || this.diagramEditorInput.getGmDiagram() == null) {
            throw new IllegalStateException("editor disposed");
        }
        return this.diagramEditorInput;
    }

    public void setBatchMode(boolean batchMode) {
        CommandStack stack = (CommandStack)this.editor.getAdapter(CommandStack.class);
        if (stack instanceof DiagramCommandStack) {
            ((DiagramCommandStack)stack).setBatchMode(batchMode);
        }
    }
}

