/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.diagrams;

import com.modeliosoft.modelio.api.diagram.IDiagramCustomizer;
import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramService;
import com.modeliosoft.modelio.api.diagram.autodiagram.IAutoDiagramFactory;
import com.modeliosoft.modelio.api.diagram.style.IStyleHandle;
import com.modeliosoft.modelio.api.diagram.tools.IAttachedBoxCommand;
import com.modeliosoft.modelio.api.diagram.tools.IBoxCommand;
import com.modeliosoft.modelio.api.diagram.tools.IDiagramCommand;
import com.modeliosoft.modelio.api.diagram.tools.ILinkCommand;
import com.modeliosoft.modelio.api.diagram.tools.IMultiLinkCommand;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramHandle;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramService;
import com.modeliosoft.modelio.api.impl.diagrams.autodiagram.AutoDiagramFactory;
import com.modeliosoft.modelio.api.impl.diagrams.style.StyleHandle;
import com.modeliosoft.modelio.api.impl.diagrams.tools.AttacherBoxToolEntry;
import com.modeliosoft.modelio.api.impl.diagrams.tools.BoxToolEntry;
import com.modeliosoft.modelio.api.impl.diagrams.tools.LinkToolEntry;
import com.modeliosoft.modelio.api.impl.diagrams.tools.MultiLinkToolEntry;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.editor.plugin.IDiagramConfigurer;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.styles.core.NamedStyle;
import com.modeliosoft.modelio.diagram.styles.plugin.DiagramStyles;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;

public class DiagramService
implements IDiagramService {
    public IAutoDiagramFactory getAutoDiagramFactory() {
        return new AutoDiagramFactory();
    }

    public IDiagramHandle getDiagramHandle(IAbstractDiagram diagram) {
        return DiagramHandle.create((IAbstractDiagram)diagram);
    }

    public ToolEntry getRegisteredTool(String id) {
        return DiagramEditor.getInstance().getToolRegistry().getTool(id);
    }

    public IStyleHandle getStyle(String name) {
        NamedStyle style = DiagramStyles.getInstance().getStyleManager().getStyle(name);
        if (style != null) {
            return new StyleHandle(style);
        }
        return null;
    }

    public List<IStyleHandle> listStyles() {
        ArrayList<IStyleHandle> results = new ArrayList<IStyleHandle>();
        for (String s : DiagramStyles.getInstance().getStyleManager().getAvailableStyles()) {
            results.add((IStyleHandle)new StyleHandle(s));
        }
        return results;
    }

    public void registerCustomizedTool(String id, Class<? extends IElement> metaclass, IStereotype stereotype, String dependency, IBoxCommand handler) {
        ModelioCreationContext context = new ModelioCreationContext(MetaModelExpert.getMetaclassName(metaclass), dependency, stereotype);
        BoxToolEntry toolentry = new BoxToolEntry(handler.getLabel(), handler.getTooltip(), (CreationFactory)context, handler.getBitmap(), handler.getBitmap(), (IDiagramCommand)handler);
        DiagramEditor.getInstance().getToolRegistry().registerTool(id, (ToolEntry)toolentry);
    }

    public void registerCustomizedTool(String id, Class<? extends IElement> metaclass, IStereotype stereotype, String dependency, IAttachedBoxCommand handler) {
        ModelioCreationContext context = new ModelioCreationContext(MetaModelExpert.getMetaclassName(metaclass), dependency, stereotype);
        AttacherBoxToolEntry toolEntry = new AttacherBoxToolEntry(handler.getLabel(), handler.getTooltip(), (CreationFactory)context, handler.getBitmap(), handler.getBitmap(), (IDiagramCommand)handler);
        DiagramEditor.getInstance().getToolRegistry().registerTool(id, (ToolEntry)toolEntry);
    }

    public void registerCustomizedTool(String id, Class<? extends IElement> metaclass, IStereotype stereotype, String dependency, ILinkCommand handler) {
        ModelioLinkCreationContext context = new ModelioLinkCreationContext(MetaModelExpert.getMetaclassName(metaclass), stereotype);
        LinkToolEntry toolEntry = new LinkToolEntry(handler.getLabel(), handler.getTooltip(), (CreationFactory)context, handler.getBitmap(), handler.getBitmap(), (IDiagramCommand)handler);
        DiagramEditor.getInstance().getToolRegistry().registerTool(id, (ToolEntry)toolEntry);
    }

    public void registerCustomizedTool(String id, Class<? extends IElement> metaclass, IStereotype stereotype, String dependency, IMultiLinkCommand handler) {
        ModelioLinkCreationContext context = new ModelioLinkCreationContext(MetaModelExpert.getMetaclassName(metaclass), stereotype);
        MultiLinkToolEntry toolEntry = new MultiLinkToolEntry(handler.getLabel(), handler.getTooltip(), (CreationFactory)context, handler.getBitmap(), handler.getBitmap(), (IDiagramCommand)handler);
        DiagramEditor.getInstance().getToolRegistry().registerTool(id, (ToolEntry)toolEntry);
    }

    public void registerDiagramCustomization(IStereotype stereotype, Class<? extends IAbstractDiagram> baseDiagramClass, IDiagramCustomizer customizer) {
        assert (stereotype != null);
        DiagramCustomizer diagramConfigurer = new DiagramCustomizer(this, baseDiagramClass, customizer);
        DiagramEditor.getInstance().getDiagramManager().registerDiagramConfigurer(MetaModelExpert.getMetaclassName(baseDiagramClass), stereotype.getName(), (IDiagramConfigurer)diagramConfigurer);
    }

    public IStyleHandle registerStyle(String styleName, String baseStyleName, File styleData) {
        File projectSpace = O.getDefault().getModelingSession().getProjectSpacePath();
        if (styleData.isFile() && styleData.exists()) {
            try {
                DiagramStyles.getInstance().getStyleManager().createStyle(projectSpace, styleName, baseStyleName, styleData.toURI().toURL());
            }
            catch (Exception e) {
                LOG.error((String)"org.modelio.api", (Throwable)e);
                return null;
            }
        } else {
            DiagramStyles.getInstance().getStyleManager().createStyle(projectSpace, styleName, baseStyleName);
        }
        return new StyleHandle(styleName);
    }

    public void unregisterDiagramCustomization(IStereotype stereotype, Class<? extends IAbstractDiagram> baseDiagramClass, IDiagramCustomizer customizer) {
        assert (stereotype != null);
        DiagramCustomizer diagramConfigurer = new DiagramCustomizer(this, baseDiagramClass, customizer);
        DiagramEditor.getInstance().getDiagramManager().unregisterDiagramConfigurer(MetaModelExpert.getMetaclassName(baseDiagramClass), stereotype.getName(), (IDiagramConfigurer)diagramConfigurer);
    }

    public void unregisterCustomizedTool(String id) {
        DiagramEditor.getInstance().getToolRegistry().unregisterTool(id);
    }
}

