/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.diagrams.dg.activity;

import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramHandle;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramNode;
import com.modeliosoft.modelio.api.impl.diagrams.dg.DGFactory;
import com.modeliosoft.modelio.diagram.editor.activity.elements.partition.GmPartition;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ActivityPartitionDG
extends DiagramNode {
    public ActivityPartitionDG(DiagramHandle diagramHandle, GmNodeModel node) {
        super(diagramHandle, node);
    }

    public List<IDiagramNode> getNodes() {
        GmCompositeNode contentsArea = ((GmPartition)this.gmNode).getContentsArea();
        if (contentsArea != null) {
            return DGFactory.getInstance().getDiagramNodes(this.diagramHandle, contentsArea.getChildren());
        }
        return Collections.emptyList();
    }

    public Rectangle getBounds() {
        GraphicalEditPart p = this.diagramHandle.getEditPart((IGmObject)this.gmNode);
        return p.getFigure().getBounds().getCopy();
    }

    public void setBounds(Rectangle newBounds) {
        if (newBounds.height == -1 || newBounds.width == -1) {
            return;
        }
        Rectangle currentBounds = this.getBounds();
        GraphicalEditPart p = this.diagramHandle.getEditPart((IGmObject)this.gmNode);
        ChangeBoundsRequest req = new ChangeBoundsRequest();
        req.setType((Object)"resize");
        req.setEditParts((EditPart)p);
        req.setMoveDelta(newBounds.getLocation().getTranslated(currentBounds.getLocation().getNegated()));
        req.setSizeDelta(new Dimension(newBounds.width - currentBounds.width, newBounds.height - currentBounds.height));
        Command com = p.getCommand((Request)req);
        if (com != null && com.canExecute()) {
            p.getViewer().getEditDomain().getCommandStack().execute(com);
        }
        req = new ChangeBoundsRequest();
        req.setType((Object)"move");
        req.setLocation(newBounds.getCenter());
        req.setEditParts((EditPart)p);
        req.setMoveDelta(newBounds.getLocation().getTranslated(currentBounds.getLocation().getNegated()));
        com = p.getCommand((Request)req);
        if (com != null && com.canExecute()) {
            p.getViewer().getEditDomain().getCommandStack().execute(com);
            p.getFigure().getUpdateManager().performValidation();
        }
    }
}

