/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.diagrams.dg.common;

import com.modeliosoft.modelio.api.diagram.IDiagramLink;
import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.diagram.dg.IDiagramDG;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramHandle;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramNode;
import com.modeliosoft.modelio.api.impl.diagrams.dg.DGFactory;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

public abstract class DiagramDG
extends DiagramNode
implements IDiagramDG {
    public DiagramDG(DiagramHandle diagramHandle, GmNodeModel node) {
        super(diagramHandle, node);
    }

    public DiagramNode getParent() {
        return null;
    }

    public List<IDiagramNode> getNodes() {
        return DGFactory.getInstance().getDiagramNodes(this.diagramHandle, ((GmCompositeNode)this.gmNode).getChildren());
    }

    public final Rectangle getBounds() {
        GraphicalEditPart p = this.diagramHandle.getEditPart((IGmObject)this.gmNode);
        return this.computeMinimumBounds(p.getFigure());
    }

    public final void setBounds(Rectangle bounds) {
    }

    public List<IDiagramLink> getFromLinks() {
        return Collections.emptyList();
    }

    public List<IDiagramLink> getToLinks() {
        return Collections.emptyList();
    }

    public List<IDiagramLink> getLinks() {
        ArrayList<IDiagramLink> links = new ArrayList<IDiagramLink>();
        for (GmModel gm : this.gmNode.getDiagram().getAllModels()) {
            IDiagramLink diagramLink;
            if (!(gm instanceof IGmLink) || (diagramLink = DGFactory.getInstance().getDiagramLink(this.diagramHandle, (IGmLink)gm)) == null) continue;
            links.add(diagramLink);
        }
        return links;
    }

    private Rectangle computeMinimumBounds(IFigure iFigure) {
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Object fig : iFigure.getChildren()) {
            Rectangle b = ((Figure)fig).getBounds();
            if (b.x < xMin) {
                xMin = b.x;
            }
            if (b.x + b.width > xMax) {
                xMax = b.x + b.width;
            }
            if (b.y < yMin) {
                yMin = b.y;
            }
            if (b.y + b.height <= yMax) continue;
            yMax = b.y + b.height;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public final boolean setLocation(int x, int y) {
        return false;
    }

    public final boolean setSize(int x, int y) {
        return false;
    }
}

