/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.diagrams.dg.common;

import com.modeliosoft.modelio.api.diagram.IDiagramLink;
import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramHandle;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramNode;
import com.modeliosoft.modelio.api.impl.diagrams.dg.DGFactory;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.GmPortContainer;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalEditPart;

public abstract class PortContainerDG
extends DiagramNode {
    public PortContainerDG(DiagramHandle diagramHandle, GmNodeModel gmNode) {
        super(diagramHandle, gmNode);
    }

    public final List<IDiagramNode> getNodes() {
        ArrayList<IDiagramNode> nodes = new ArrayList<IDiagramNode>();
        List children = this.getPrimaryChildrenNodes();
        if (children != null) {
            nodes.addAll(children);
        }
        GmPortContainer pc = (GmPortContainer)this.gmNode;
        for (GmNodeModel gm : pc.getChildren()) {
            IDiagramNode diagramNode;
            if (!pc.isPort(gm) && !pc.isSatellite(gm) || (diagramNode = DGFactory.getInstance().getDiagramNode(this.diagramHandle, gm)) == null) continue;
            nodes.add(diagramNode);
        }
        return nodes;
    }

    public List<IDiagramLink> getFromLinks() {
        GmNodeModel mainNode = ((GmPortContainer)this.gmNode).getMainNode();
        ArrayList<IDiagramLink> links = new ArrayList<IDiagramLink>();
        for (IGmLink gmLink : mainNode.getStartingLinks()) {
            IDiagramLink diagramLink = DGFactory.getInstance().getDiagramLink(this.diagramHandle, gmLink);
            if (diagramLink == null) continue;
            links.add(diagramLink);
        }
        return links;
    }

    public List<IDiagramLink> getToLinks() {
        GmNodeModel mainNode = ((GmPortContainer)this.gmNode).getMainNode();
        ArrayList<IDiagramLink> links = new ArrayList<IDiagramLink>();
        for (IGmLink gmLink : mainNode.getEndingLinks()) {
            IDiagramLink diagramLink = DGFactory.getInstance().getDiagramLink(this.diagramHandle, gmLink);
            if (diagramLink == null) continue;
            links.add(diagramLink);
        }
        return links;
    }

    protected final GmNodeModel getPrimaryNode() {
        return ((GmPortContainer)this.gmNode).getMainNode();
    }

    protected abstract List<IDiagramNode> getPrimaryChildrenNodes();

    protected Dimension getMinimumSize() {
        GraphicalEditPart mainNodeEditPart;
        GmPortContainer gpc = (GmPortContainer)this.gmNode;
        GmNodeModel mainNode = gpc.getMainNode();
        if (mainNode != null && (mainNodeEditPart = this.diagramHandle.getEditPart((IGmObject)mainNode)) != null) {
            IFigure mainFig = mainNodeEditPart.getFigure();
            return mainFig.getMinimumSize();
        }
        return super.getMinimumSize();
    }
}

