/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.diagrams.tools;

import com.modeliosoft.modelio.api.diagram.IDiagramGraphic;
import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramLink;
import com.modeliosoft.modelio.api.diagram.tools.IMultiLinkCommand;
import com.modeliosoft.modelio.api.impl.diagrams.DiagramHandle;
import com.modeliosoft.modelio.api.impl.diagrams.dg.DGFactory;
import com.modeliosoft.modelio.api.impl.diagrams.dg.LinkPath;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.diagram.editor.AbstractDiagramEditor;
import com.modeliosoft.modelio.diagram.editor.IDiagramEditor;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmModelRelated;
import com.modeliosoft.modelio.diagram.elements.core.tools.multipoint.MultiPointCreationTool;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;

public class MultiLinkTool
extends MultiPointCreationTool {
    protected IMultiLinkCommand multiLinkCommand = null;
    public static final Object PROPERTY_HANDLER = "handler";
    private DiagramHandle diagramHandle = null;

    protected void executeCurrentCommand() {
        if (this.getTargetEditPart() == null) {
            return;
        }
        GmModel targetModel = (GmModel)this.getTargetEditPart().getModel();
        this.initDiagramHandle(targetModel);
        IDiagramGraphic lastNode = null;
        while (lastNode == null && targetModel != null) {
            lastNode = DGFactory.getInstance().getDiagramGraphic(this.diagramHandle, (IGmModelRelated)targetModel);
            targetModel = targetModel.getParent();
        }
        List otherNodes = this.getOtherNodes();
        otherNodes.remove(lastNode);
        Point where = this.getTargetRequest().getLocation();
        Dimension size = this.getTargetRequest().getSize() != null ? this.getTargetRequest().getSize() : new Dimension(-1, -1);
        Rectangle rect = new Rectangle(where, size);
        ((GraphicalEditPart)this.getTargetEditPart().getViewer().getContents()).getFigure().translateToRelative((Translatable)rect);
        ArrayList<LinkPath> paths = new ArrayList<LinkPath>();
        ArrayList<IDiagramLink.LinkRouterKind> routerList = new ArrayList<IDiagramLink.LinkRouterKind>();
        int i = 0;
        while (i < otherNodes.size()) {
            paths.add(new LinkPath());
            routerList.add(IDiagramLink.LinkRouterKind.BENDPOINT);
            ++i;
        }
        this.multiLinkCommand.actionPerformed((IDiagramHandle)this.diagramHandle, lastNode, otherNodes, routerList, paths, rect);
        this.setCurrentCommand(null);
    }

    private List<IDiagramGraphic> getOtherNodes() {
        ArrayList<IDiagramGraphic> otherNodes = new ArrayList<IDiagramGraphic>();
        for (EditPart ep : this.getTargetRequest().getAcceptedEditParts()) {
            GmModel targetModel = (GmModel)ep.getModel();
            IDiagramGraphic dg = null;
            while (dg == null && targetModel != null) {
                dg = DGFactory.getInstance().getDiagramGraphic(this.diagramHandle, (IGmModelRelated)targetModel);
                targetModel = targetModel.getParent();
            }
            if (dg == null) continue;
            otherNodes.add(dg);
        }
        return otherNodes;
    }

    protected void applyProperty(Object key, Object value) {
        if (PROPERTY_HANDLER.equals(key)) {
            if (value instanceof IMultiLinkCommand) {
                this.multiLinkCommand = (IMultiLinkCommand)value;
            }
            return;
        }
        super.applyProperty(key, value);
    }

    protected EditPartViewer.Conditional getTargetingConditional() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected boolean doAccept(EditPart editpart) {
        GmModel targetModel = (GmModel)editpart.getModel();
        this.initDiagramHandle(targetModel);
        IDiagramGraphic dg = null;
        while (dg == null && targetModel != null) {
            dg = DGFactory.getInstance().getDiagramGraphic(this.diagramHandle, (IGmModelRelated)targetModel);
            targetModel = targetModel.getParent();
        }
        if (dg == null) {
            return false;
        }
        if (this.getTargetRequest().getType().equals("Multipoint First")) {
            if (this.multiLinkCommand.acceptFirstElement((IDiagramHandle)this.diagramHandle, dg)) {
                return true;
            }
            if (this.multiLinkCommand.acceptLastElement((IDiagramHandle)this.diagramHandle, this.getOtherNodes(), dg)) {
                this.getTargetRequest().setType((Object)"MultiPoint Last");
                return true;
            }
        } else if (this.getTargetRequest().getType().equals("MultiPoint Additional")) {
            if (this.multiLinkCommand.acceptAdditionalElement((IDiagramHandle)this.diagramHandle, this.getOtherNodes(), dg)) {
                return true;
            }
            if (this.multiLinkCommand.acceptLastElement((IDiagramHandle)this.diagramHandle, this.getOtherNodes(), dg)) {
                this.getTargetRequest().setType((Object)"MultiPoint Last");
                return true;
            }
        }
        return false;
    }

    private void initDiagramHandle(GmModel targetModel) {
        if (this.diagramHandle == null) {
            IAbstractDiagram diagram = (IAbstractDiagram)targetModel.getDiagram().getRepresentedIElement();
            AbstractDiagramEditor editor = DiagramEditor.getInstance().getRegistry().get(diagram);
            this.diagramHandle = DiagramHandle.create((IDiagramEditor)editor);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.diagramHandle != null) {
            this.diagramHandle.close();
            this.diagramHandle = null;
        }
    }

    static /* synthetic */ EditPartViewer.Conditional access$0(MultiLinkTool multiLinkTool) {
        return super.getTargetingConditional();
    }
}

