/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.editor;

import com.modeliosoft.modelio.api.editor.IEditionService;
import com.modeliosoft.modelio.api.editor.IMDATextEditor;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.documents.DocumentCreator;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.core.documents.SupportLevel;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.edition.texteditors.edition.EditionManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EditionService
implements IEditionService {
    public void closeEditor(IMDATextEditor editor) {
        EditionManager.closeEditor((IMDATextEditor)editor);
    }

    public IMDATextEditor openEditor(IModelElement modelElement, File file, String editorTypeID, boolean readonly) {
        return EditionManager.openEditor((IModelElement)modelElement, (File)file, (String)editorTypeID, (boolean)readonly);
    }

    public void activateEditor(IMDATextEditor editor) {
        EditionManager.activateEditor((IMDATextEditor)editor);
    }

    public void openEditor(IAbstractDiagram diagram) {
        if (DiagramEditor.getInstance().getRegistry().get(diagram) == null) {
            O.getDefault().getActivationService().fireActivate((IElement)diagram);
        }
    }

    public void openEditor(IArtifact artifact) {
        O.getDefault().getActivationService().fireActivate((IElement)artifact);
    }

    public void openEditor(IExternDocument document) {
        O.getDefault().getActivationService().fireActivate((IElement)document);
    }

    public List<String> getSupportedMimeTypes() {
        Collection formats = O.getDefault().getDocumentFormatsRegistry().getAllFormats();
        ArrayList<String> ret = new ArrayList<String>(formats.size());
        for (DocumentFormat f : formats) {
            if (f.getSupportLevel() != SupportLevel.Primary) continue;
            ret.add(f.getMimeType());
        }
        return ret;
    }

    public boolean createDocumentContent(IExternDocument doc) throws IOException {
        return DocumentCreator.createDocument((IExternDocument)doc);
    }
}

