/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.exchange;

import com.modeliosoft.modelio.api.exchange.IExchangeService;
import com.modeliosoft.modelio.api.exchange.XmiException;
import com.modeliosoft.modelio.api.exchange.XmiExportConfiguration;
import com.modeliosoft.modelio.api.exchange.XmiImportConfiguration;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.xmi.api.ExportConfiguration;
import com.modeliosoft.modelio.xmi.api.ImportConfiguration;
import com.modeliosoft.modelio.xmi.api.VersionExport;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExchangeService
implements IExchangeService {
    public void exportXmiFile(XmiExportConfiguration configuration, IProgressMonitor monitor) throws XmiException {
        ExportConfiguration exportConf = new ExportConfiguration();
        IPackage entryPoint = configuration.getEntryPoint();
        exportConf.setEntryPoint(entryPoint);
        exportConf.setExportedAnotation(Boolean.valueOf(configuration.isExportAnnotations()));
        exportConf.setVersionExport(VersionExport.valueOf((String)configuration.getVersionExport().name()));
        exportConf.setXmiFile(configuration.getXmiFile());
        try {
            if (entryPoint instanceof IProfile) {
                XMI.getInstance().exportXMIProfile(exportConf);
            } else {
                XMI.getInstance().exportXMIFile(exportConf);
            }
        }
        catch (Exception e) {
            throw new XmiException(e);
        }
    }

    public void importXmiFile(XmiImportConfiguration configuration, IProgressMonitor monitor) throws XmiException {
        block4: {
            ImportConfiguration importConf = new ImportConfiguration();
            IElement owner = configuration.getOwner();
            importConf.setOwner(owner);
            importConf.setXmiFile(configuration.getXmiFile());
            try {
                if (owner instanceof IModule) {
                    XMI.getInstance().importXMIProfile(importConf);
                    break block4;
                }
                if (owner instanceof IPackage) {
                    XMI.getInstance().importXMIModel(importConf);
                    break block4;
                }
                throw new XmiException("Owner must be an IPackage or an IModule");
            }
            catch (Exception e) {
                throw new XmiException(e);
            }
        }
    }
}

