/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.mc;

import com.modeliosoft.modelio.api.impl.mc.ModelComponentDescriptor;
import com.modeliosoft.modelio.api.mc.IModelComponentDescriptor;
import com.modeliosoft.modelio.api.mc.IModelComponentService;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.module.IPeerMdac;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.ramcs.deployer.RamcDeployer;
import com.modeliosoft.modelio.ramcs.packager.RamcPackager;
import com.modeliosoft.modelio.ramcs.remove.DeleteModelComponents;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ModelComponentService
implements IModelComponentService {
    public void deployModelComponent(File archive, IProgressMonitor monitor) {
        RamcDeployer deployer = new RamcDeployer();
        deployer.deployRamc(O.getDefault().getModelingSession(), archive, Modelio.getInstance().getContext().getProjectSpacePath(), monitor);
    }

    public void removeModelComponent(IModelComponentDescriptor modelComponent) {
        ArrayList<IArtifact> modelComponentsToRemove = new ArrayList<IArtifact>();
        IArtifact artifact = this.getArtifact(modelComponent);
        if (artifact == null) {
            return;
        }
        modelComponentsToRemove.add(artifact);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            DeleteModelComponents deleteModelComponents = new DeleteModelComponents(O.getDefault().getModelingSession(), modelComponentsToRemove);
            service.run(true, false, (IRunnableWithProgress)deleteModelComponents);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public List<IModelComponentDescriptor> getModelComponents() {
        ArrayList<IModelComponentDescriptor> mcList = new ArrayList<IModelComponentDescriptor>();
        ObList components = Modelio.getInstance().getModelingSession().getModel().getRoot().getOwnedElement(IComponent.class);
        for (IModelTree component : components) {
            if (!(component instanceof IComponent) || !component.isStereotyped("ModelComponent")) continue;
            ObList artifacts = component.getOwnedElement(IArtifact.class);
            for (IArtifact artifact : artifacts) {
                if (!artifact.isStereotyped("ModelComponentArchive")) continue;
                mcList.add(this.getModelComponentDescriptor(artifact));
            }
            ObList moduleComponents = component.getOwnedElement(IComponent.class);
            for (IModelTree moduleComponent : moduleComponents) {
                if (!(moduleComponent instanceof IComponent) || !moduleComponent.isStereotyped("JMDAComponent")) continue;
                ObList moduleArtifacts = moduleComponent.getOwnedElement(IArtifact.class);
                for (IArtifact moduleArtifact : moduleArtifacts) {
                    if (!moduleArtifact.isStereotyped("ModelComponentArchive")) continue;
                    mcList.add(this.getModelComponentDescriptor(moduleArtifact));
                }
            }
        }
        return mcList;
    }

    private Version getVersion(IArtifact artifact) {
        ObList taggedValues = artifact.getTag();
        for (ITaggedValue taggedValue : taggedValues) {
            ObList parameters;
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion") || (parameters = taggedValue.getActual()).size() != 1) continue;
            return new Version(((ITagParameter)parameters.get(0)).getValue());
        }
        return null;
    }

    private IModelComponentDescriptor getModelComponentDescriptor(IArtifact artifact) {
        return new ModelComponentDescriptor(artifact.getName(), this.getVersion(artifact).toString());
    }

    private IArtifact getArtifact(IModelComponentDescriptor descriptor) {
        ObList components = Modelio.getInstance().getModelingSession().getModel().getRoot().getOwnedElement(IComponent.class);
        for (IModelTree component : components) {
            if (!(component instanceof IComponent) || !component.isStereotyped("ModelComponent")) continue;
            ObList artifacts = component.getOwnedElement(IArtifact.class);
            for (IArtifact artifact : artifacts) {
                IModelComponentDescriptor mcDescriptor;
                if (!artifact.isStereotyped("ModelComponentArchive") || !(mcDescriptor = this.getModelComponentDescriptor(artifact)).equals(descriptor)) continue;
                return artifact;
            }
            ObList moduleComponents = component.getOwnedElement(IComponent.class);
            for (IModelTree moduleComponent : moduleComponents) {
                if (!(moduleComponent instanceof IComponent) || !moduleComponent.isStereotyped("JMDAComponent")) continue;
                ObList moduleArtifacts = moduleComponent.getOwnedElement(IArtifact.class);
                for (IArtifact moduleArtifact : moduleArtifacts) {
                    IModelComponentDescriptor mcDescriptor;
                    if (!moduleArtifact.isStereotyped("ModelComponentArchive") || !(mcDescriptor = this.getModelComponentDescriptor(moduleArtifact)).equals(descriptor)) continue;
                    return moduleArtifact;
                }
            }
        }
        return null;
    }

    public void packageModelComponent(IArtifact mc, Set<IPeerMdac> peerMdacs, File targetFile, IProgressMonitor monitor) {
        RamcPackager packager = new RamcPackager();
        packager.packageRamc(mc, peerMdacs, targetFile, monitor);
    }
}

