/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.impl.model;

import com.modeliosoft.modelio.api.model.IAnalystModel;
import com.modeliosoft.modelio.api.model.analyst.IAnalystProject;
import com.modeliosoft.modelio.api.model.analyst.IDictionary;
import com.modeliosoft.modelio.api.model.analyst.IEnumeratedPropertyType;
import com.modeliosoft.modelio.api.model.analyst.IProperty;
import com.modeliosoft.modelio.api.model.analyst.IPropertyEnumerationLitteral;
import com.modeliosoft.modelio.api.model.analyst.IPropertySet;
import com.modeliosoft.modelio.api.model.analyst.IPropertyType;
import com.modeliosoft.modelio.api.model.analyst.IPropertyValue;
import com.modeliosoft.modelio.api.model.analyst.IPropertyValueSet;
import com.modeliosoft.modelio.api.model.analyst.IRequirement;
import com.modeliosoft.modelio.api.model.analyst.IRequirementContainer;
import com.modeliosoft.modelio.api.model.analyst.ITerm;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.IModel;

public class AnalystModel
implements IAnalystModel {
    private IModelFactory coreFactory;
    private IModel model;

    public AnalystModel(IModelFactory coreFactory, IModel imodel) {
        this.coreFactory = coreFactory;
        this.model = imodel;
    }

    public IDictionary createDictionary() {
        return this.coreFactory.createDictionary();
    }

    public IEnumeratedPropertyType createEnumeratedPropertyType() {
        return this.coreFactory.createEnumeratedPropertyType();
    }

    public IProperty createProperty() {
        return this.coreFactory.createProperty();
    }

    public IPropertyEnumerationLitteral createPropertyEnumerationLitteral() {
        return this.coreFactory.createPropertyEnumerationLitteral();
    }

    public IPropertySet createPropertySet() {
        return this.coreFactory.createPropertySet();
    }

    public IPropertyType createPropertyType() {
        return this.coreFactory.createPropertyType();
    }

    public IPropertyValue createPropertyValue() {
        return this.coreFactory.createPropertyValue();
    }

    public IPropertyValueSet createPropertyValueSet() {
        return this.coreFactory.createPropertyValueSet();
    }

    public IRequirement createRequirement() {
        return this.coreFactory.createRequirement();
    }

    public IRequirementContainer createRequirementContainer() {
        return this.coreFactory.createRequirementContainer();
    }

    public ITerm createTerm() {
        return this.coreFactory.createTerm();
    }

    public void deleteElement(IElement element) {
        this.coreFactory.deleteElement(element);
    }

    public IRequirementContainer getRootBusinessRuleContainer() {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            return reqProject.getBusinessRuleRoot();
        }
        return null;
    }

    public IDictionary getRootDictionary() {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            return reqProject.getDictionaryRoot();
        }
        return null;
    }

    public IRequirementContainer getRootGoalContainer() {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            return reqProject.getGoalRoot();
        }
        return null;
    }

    public IRequirementContainer getRootRequirementContainer() {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            return reqProject.getRequirementRoot();
        }
        return null;
    }

    public ObList<IPropertyType> getPropertyTypes() {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            return reqProject.getProperties().getDefinedType();
        }
        return null;
    }

    public ObList<IPropertySet> getPropertySets() {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            return reqProject.getProperties().getDefinedPropertySet();
        }
        return null;
    }

    public void addPropertyType(IPropertyType type) {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            reqProject.getProperties().addDefinedType(type);
        }
    }

    public void removePropertyType(IPropertyType type) {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            reqProject.getProperties().removeDefinedType(type);
        }
    }

    public void addPropertySet(IPropertySet set) {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            reqProject.getProperties().addDefinedPropertySet(set);
        }
    }

    public void removePropertySet(IPropertySet set) {
        IAnalystProject reqProject = this.getProject().getRootRequirement();
        if (reqProject != null) {
            reqProject.getProperties().removeDefinedPropertySet(set);
        }
    }

    private IProject getProject() {
        return this.model.getProject();
    }
}

