/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.association;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.ObAggregationKindEnum;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.statik.elements.association.GmAssocStructuredStyleKeys;
import com.modeliosoft.modelio.diagram.editor.statik.elements.association.GmRoleNameLabel;
import com.modeliosoft.modelio.diagram.editor.statik.elements.assocqualifier.GmQualifierGroup;
import com.modeliosoft.modelio.diagram.editor.statik.elements.rolecardinalitylabel.GmRoleCardinalityLabel;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.label.modelelement.GmDefaultFlatHeader;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.GmFractionalConnectionLocator;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.IGmLocator;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.umlcommon.informationflowgroup.GmInfoFlowsGroup;
import com.modeliosoft.modelio.diagram.elements.umlcommon.informationflowgroup.GmInformationFlowArrow;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.List;

public class GmAssociation
extends GmLink {
    private IAssociationEnd role;
    private static final GmAssocStructuredStyleKeys STRUCTURED_KEYS = new GmAssocStructuredStyleKeys();
    private boolean fromNavigable;
    private boolean toNavigable;
    private ObRef roleRef = null;
    private IAssociation association;
    private ObAggregationKindEnum fromAggregation;
    private ObAggregationKindEnum toAggregation;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmAssociation() {
    }

    public GmAssociation(GmAbstractDiagram diagram, IAssociationEnd role, ObRef roleRef, ObRef associationRef) {
        super(diagram, associationRef);
        this.roleRef = roleRef;
        this.role = role;
        if (role != null) {
            this.association = this.role.getRelated();
            IAssociationEnd oppositeRole = this.getOppositeRole();
            if (oppositeRole != null) {
                this.fromNavigable = oppositeRole.isNavigable();
                this.toAggregation = oppositeRole.getAggregation();
            }
            this.fromAggregation = this.role.getAggregation();
            this.toNavigable = this.role.isNavigable();
            ObRef oppositeRoleRef = new ObRef((IElement)oppositeRole);
            this.addExtension((GmNodeModel)new GmQualifierGroup(diagram, roleRef, role), null);
            this.addExtension((GmNodeModel)new GmQualifierGroup(diagram, oppositeRoleRef, oppositeRole), null);
            this.addExtension("sourceNW", (GmNodeModel)new GmRoleNameLabel(diagram, oppositeRole, oppositeRoleRef));
            this.addExtension("SourceSE", (GmNodeModel)new GmRoleCardinalityLabel(diagram, oppositeRole, oppositeRoleRef));
            GmFractionalConnectionLocator constraint = new GmFractionalConnectionLocator(0.25, 0, -10);
            this.addExtension((GmNodeModel)new GmInfoFlowsGroup(diagram, oppositeRoleRef), (IGmLocator)constraint);
            constraint = new GmFractionalConnectionLocator(0.25, 0, 0, false);
            this.addExtension((GmNodeModel)new GmInformationFlowArrow(diagram, oppositeRoleRef), (IGmLocator)constraint);
            this.addExtension("TargetNW", (GmNodeModel)new GmRoleNameLabel(diagram, this.role, roleRef));
            this.addExtension("TargetSE", (GmNodeModel)new GmRoleCardinalityLabel(diagram, this.role, roleRef));
            constraint = new GmFractionalConnectionLocator(0.75, 0, -10);
            this.addExtension((GmNodeModel)new GmInfoFlowsGroup(diagram, roleRef), (IGmLocator)constraint);
            constraint = new GmFractionalConnectionLocator(0.75, 0, 0, true);
            this.addExtension((GmNodeModel)new GmInformationFlowArrow(diagram, roleRef), (IGmLocator)constraint);
            this.addExtension("MiddleSE", (GmNodeModel)new GmDefaultFlatHeader(diagram, associationRef));
        }
    }

    public ObAggregationKindEnum getFromAggregation() {
        return this.fromAggregation;
    }

    public IElement getFromElement() {
        return this.role.getOwner();
    }

    public IAssociation getRelatedIElement() {
        return this.association;
    }

    public IAssociation getRepresentedIElement() {
        return this.association;
    }

    public IAssociationEnd getRepresentedRole() {
        return this.role;
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        return STRUCTURED_KEYS.getStyleKey(metakey);
    }

    public List<StyleKey> getStyleKeys() {
        return STRUCTURED_KEYS.getStyleKeys();
    }

    public ObAggregationKindEnum getToAggregation() {
        return this.toAggregation;
    }

    public IElement getToElement() {
        return ((IAssociationEnd)this.role.getOppositeEnds().get(0)).getOwner();
    }

    public boolean isFromNavigable() {
        return this.fromNavigable;
    }

    public boolean isToNavigable() {
        return this.toNavigable;
    }

    public void refreshFromObModel() {
        super.refreshFromObModel();
        IAssociationEnd opposite = this.getOppositeRole();
        if (opposite != null && opposite.isValid()) {
            this.toAggregation = opposite.getAggregation();
            this.fromNavigable = opposite.isNavigable();
        }
        if (this.role != null && this.role.isValid()) {
            this.fromAggregation = this.role.getAggregation();
            this.toNavigable = this.role.isNavigable();
        }
        this.firePropertyChange("LayoutData", null, (Object)this);
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("representedRole", this.roleRef);
        if (false) {
            out.writeProperty("GmAssociation.version", (Object)0);
        }
    }

    IAssociationEnd getOppositeRole() {
        if (this.role == null || !this.role.isValid()) {
            return null;
        }
        ObList oppositeEnds = this.role.getOppositeEnds();
        if (oppositeEnds.isEmpty()) {
            return null;
        }
        return (IAssociationEnd)oppositeEnds.get(0);
    }

    protected void readLink(IDiagramReader in) {
        this.roleRef = (ObRef)in.readProperty("representedRole");
        this.role = (IAssociationEnd)this.resolveRef(this.roleRef);
        this.association = (IAssociation)this.resolveRef(this.getRepresentedRef());
        if (this.role != null) {
            IAssociationEnd opposite = this.getOppositeRole();
            if (opposite != null) {
                this.fromNavigable = opposite.isNavigable();
                this.toAggregation = opposite.getAggregation();
            } else {
                this.fromNavigable = false;
                this.toAggregation = ObAggregationKindEnum.KIND_IS_ASSOCIATION;
            }
            this.fromAggregation = this.role.getAggregation();
            this.toNavigable = this.role.isNavigable();
        } else {
            this.fromAggregation = ObAggregationKindEnum.KIND_IS_ASSOCIATION;
            this.fromNavigable = false;
            this.toNavigable = true;
            this.toAggregation = ObAggregationKindEnum.KIND_IS_ASSOCIATION;
        }
    }

    public ObRef getRepresentedRoleRef() {
        return this.roleRef;
    }

    public int getMajorVersion() {
        return 0;
    }
}

