/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.assocqualifier;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IFeature;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.statik.elements.association.GmAssociation;
import com.modeliosoft.modelio.diagram.editor.statik.elements.attribute.GmAttribute;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.group.GmGroup;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;

public class GmQualifierGroup
extends GmGroup {
    private IAssociationEnd role;
    private boolean visible = false;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmQualifierGroup() {
    }

    public GmQualifierGroup(GmAbstractDiagram diagram, ObRef relatedRef, IAssociationEnd role) {
        super(diagram, relatedRef);
        this.role = role;
    }

    public boolean canContain(Class<? extends GmNodeModel> nodeClass) {
        return GmAttribute.class.isAssignableFrom(nodeClass);
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return IAttribute.class.isAssignableFrom(type);
    }

    public IAssociationEnd getRelatedIElement() {
        return this.role;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void refreshFromObModel() {
        super.refreshFromObModel();
        if (this.role != null && this.role.isValid()) {
            boolean childAdded = false;
            for (IFeature part : this.role.getQualifier()) {
                if (this.getChild(new ObRef((IElement)part)) != null) continue;
                this.getDiagram().unmask((GmCompositeNode)this, (IElement)part, null);
                childAdded = true;
            }
            if (childAdded && !this.isVisible()) {
                this.setVisible(true);
            }
        }
    }

    protected void doSetVisible(boolean vis) {
        this.visible = vis;
    }

    protected boolean isValidElement(IElement el) {
        if (!(el instanceof IAttribute) || !el.isValid()) {
            return false;
        }
        return el.getCompositionOwner().equals((Object)this.getRelatedIElement());
    }

    protected void updateHiddenFeatures() {
    }

    protected void updateStyle(GmLink parentLink) {
        IGmLinkable gmRef = this.getReferenceNode();
        if (gmRef != null) {
            this.getStyle().setCascadedStyle(gmRef.getStyle());
        } else {
            this.getStyle().setCascadedStyle(this.getDiagram().getStyle());
        }
    }

    protected IGmLinkable getReferenceNode() {
        GmAssociation gmAssoc = (GmAssociation)this.getParentLink();
        if (gmAssoc == null) {
            return null;
        }
        if (this.getRepresentedRef().equals((Object)gmAssoc.getRepresentedRoleRef())) {
            return gmAssoc.getFrom();
        }
        return gmAssoc.getTo();
    }

    public StyleKey getStyleKey(MetaKey metaKey) {
        IGmLinkable gmRef = this.getReferenceNode();
        if (gmRef != null) {
            return gmRef.getStyleKey(metaKey);
        }
        return null;
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmQualifierGroup.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmQualifierGroup.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.role = (IAssociationEnd)this.resolveRef(this.getRepresentedRef());
        this.visible = !this.getChildren().isEmpty();
    }

    public int getMajorVersion() {
        return 0;
    }
}

