/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.binding;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IBinding;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.label.modelelement.GmModelElementFlatHeader;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.Collections;
import java.util.List;

public class GmBindingLabel
extends GmModelElementFlatHeader {
    private IBinding element;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmBindingLabel() {
    }

    public GmBindingLabel(GmAbstractDiagram diagram, IBinding el, ObRef ref) {
        super(diagram, ref);
        this.element = el;
        this.init();
    }

    public List<IStereotype> filterStereotypes(List<IStereotype> stereotypes) {
        return stereotypes;
    }

    public List<ITaggedValue> filterTags(List<ITaggedValue> taggedValues) {
        return taggedValues;
    }

    public IEditableText getEditableText() {
        return null;
    }

    public IBinding getRelatedIElement() {
        return this.element;
    }

    public IBinding getRepresentedIElement() {
        return this.element;
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        if (metakey == MetaKey.FONT) {
            return super.getStyleKey(MetaKey.AttGroup.ATTFONT);
        }
        if (metakey == MetaKey.SHOWSTEREOTYPES) {
            return super.getStyleKey(MetaKey.AttGroup.ATTSHOWSTEREOTYPES);
        }
        if (metakey == MetaKey.SHOWTAGS) {
            return super.getStyleKey(MetaKey.AttGroup.ATTSHOWTAGS);
        }
        if (metakey == MetaKey.TEXTCOLOR) {
            return super.getStyleKey(MetaKey.AttGroup.ATTTEXTCOLOR);
        }
        return null;
    }

    public List<StyleKey> getStyleKeys() {
        return Collections.emptyList();
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmBindingLabel.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    protected String computeLabel() {
        return this.computeSignature(this.getRelatedIElement());
    }

    protected void setParent(GmCompositeNode parent) {
        if (this.getParent() != parent) {
            super.setParent(parent);
            if (parent != null) {
                this.getStyle().setCascadedStyle(parent.getStyle());
            }
        }
    }

    private String computeSignature(IBinding att) {
        IModelElement feature = att.getRepresentedFeature();
        IModelElement collabRole = this.getBindingRole(att);
        String featureName = "<not bound>";
        if (feature != null) {
            featureName = feature.getName();
        }
        String roleName = "<none>";
        if (collabRole != null) {
            roleName = collabRole.getName();
        }
        return String.valueOf(roleName) + " -> " + featureName;
    }

    private IModelElement getBindingRole(IBinding el) {
        IBindableInstance role = el.getRole();
        if (role == null) {
            role = el.getConnectorRole();
        }
        if (role == null) {
            role = el.getConnectorEndRole();
        }
        return role;
    }

    private void init() {
        this.setShowMetaclassKeyword(false);
        this.setShowMetaclassIcon(false);
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmBindingLabel.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.element = (IBinding)this.resolveRef(this.getRepresentedRef());
    }

    public int getMajorVersion() {
        return 0;
    }
}

