/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.classifier;

import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.diagram.editor.statik.elements.classifier.ClassifierElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.editor.statik.elements.innerclass.GmInnerClass;
import com.modeliosoft.modelio.diagram.editor.statik.elements.innerclass.GmInnerClassesZone;
import com.modeliosoft.modelio.diagram.editor.statik.elements.namespacinglink.GmCompositionLink;
import com.modeliosoft.modelio.diagram.editor.statik.elements.namespacinglink.redraw.RedrawCompositionLinkEditPolicy;
import com.modeliosoft.modelio.diagram.editor.statik.elements.naryassoc.AcceptNAssocEditPolicy;
import com.modeliosoft.modelio.diagram.editor.statik.elements.policies.SmartGeneralizationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.LinkedNodeStartCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.resizablegroup.GmResizableGroup;
import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.ToolbarLayoutWithGrab;
import com.modeliosoft.modelio.diagram.elements.core.figures.borders.ShadowBorder;
import com.modeliosoft.modelio.diagram.elements.core.figures.borders.ZoomableLineBorder;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.policies.DeferringCreateNodePolicy;
import com.modeliosoft.modelio.diagram.elements.umlcommon.constraint.ConstraintLinkEditPolicy;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;

public class ClassifierEditPart
extends GmNodeEditPart {
    static final int DEFAULT_HEIGHT = 50;
    static final int DEFAULT_WIDTH = 100;
    static final int MARGIN = 20;

    public boolean isSelectable() {
        return false;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new DeferringCreateNodePolicy());
        this.installEditPolicy((Object)"NodeEditPolicy", (EditPolicy)new SmartGeneralizationEditPolicy());
        this.installEditPolicy((Object)"Linked node start", (EditPolicy)new LinkedNodeStartCreationEditPolicy());
        this.installEditPolicy((Object)"Constraint creation", (EditPolicy)new ConstraintLinkEditPolicy(false));
        GmNodeModel model = (GmNodeModel)this.getModel();
        if (model.getRelatedIElement() instanceof IClassifier) {
            this.installEditPolicy((Object)"N-ary assoc", (EditPolicy)new AcceptNAssocEditPolicy(true));
            this.installEditPolicy((Object)"DROPELEMENT", (EditPolicy)new ClassifierElementDropEditPolicy());
        } else {
            this.installEditPolicy((Object)"DROPELEMENT", (EditPolicy)new DefaultElementDropEditPolicy());
        }
        this.installEditPolicy((Object)"RedrawCompositionLinkEditPolicy", (EditPolicy)new RedrawCompositionLinkEditPolicy());
    }

    protected IFigure createFigure() {
        GradientFigure classFigure = new GradientFigure();
        classFigure.setOpaque(true);
        classFigure.setPreferredSize(new Dimension(150, 100));
        ToolbarLayoutWithGrab layout = new ToolbarLayoutWithGrab();
        layout.setHorizontal(false);
        layout.setStretchMinorAxis(true);
        classFigure.setLayoutManager((LayoutManager)layout);
        this.refreshFromStyle((IFigure)classFigure, this.getModelStyle());
        return classFigure;
    }

    protected void refreshFromStyle(IFigure aFigure, IStyle style) {
        if (aFigure instanceof GradientFigure) {
            GmInnerClass inner;
            GmNodeModel firstChild;
            GmCompositeNode model = (GmCompositeNode)this.getModel();
            if (model.getRepresentationMode() == StyleKey.RepresentationMode.SIMPLE && (firstChild = model.getFirstChild("")) instanceof GmResizableGroup && (inner = (GmInnerClass)((GmResizableGroup)firstChild).getFirstChild("Inner")) != null) {
                for (GmNodeModel gmCompositeNode : inner.getChildren()) {
                    if (!(gmCompositeNode instanceof GmInnerClassesZone)) continue;
                    for (GmNodeModel child : ((GmInnerClassesZone)gmCompositeNode).getChildren()) {
                        child.setRoleInComposition("body content as satellite");
                        Rectangle constraint = (Rectangle)child.getLayoutData();
                        if (constraint.x() < 120 && constraint.y() < 70) {
                            constraint.setY(70);
                        }
                        ((GmInnerClassesZone)gmCompositeNode).removeChild(child);
                        model.getParentNode().addChild(child);
                        GmCompositionLink link = new GmCompositionLink(model.getDiagram(), model.getRepresentedRef());
                        model.addStartingLink((IGmLink)link);
                        child.addEndingLink((IGmLink)link);
                    }
                }
            }
            if (!this.switchRepresentationMode()) {
                super.refreshFromStyle(aFigure, style);
                this.updateFigureBorder(aFigure);
            } else {
                GmCompositeNode surroundingPortContainer = model.getParentNode();
                GmCompositeNode ancestor = surroundingPortContainer.getParentNode();
                int index = ancestor.getChildIndex((GmNodeModel)surroundingPortContainer);
                ancestor.removeChild((GmNodeModel)surroundingPortContainer);
                ancestor.addChild((GmNodeModel)surroundingPortContainer, index);
            }
        }
    }

    protected void refreshVisuals() {
        IFigure fig = this.getFigure();
        GmNodeModel gm = (GmNodeModel)this.getModel();
        fig.getParent().setConstraint(fig, gm.getLayoutData());
    }

    private void updateFigureBorder(IFigure aFigure) {
        GradientFigure classFig = (GradientFigure)aFigure;
        ZoomableLineBorder inner = new ZoomableLineBorder(classFig.getLineColor(), classFig.getLineWidth());
        ShadowBorder outer = new ShadowBorder(classFig.getLineColor(), classFig.getLineWidth());
        CompoundBorder b = new CompoundBorder((Border)outer, (Border)inner);
        classFig.setBorder((Border)b);
    }
}

