/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.classifier;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.diagram.editor.statik.elements.classifier.SmartCreateCollabUseCommand;
import com.modeliosoft.modelio.diagram.editor.statik.elements.classifier.SmartCreatePartCommand;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class ClassifierElementDropEditPolicy
extends DefaultElementDropEditPolicy {
    protected EditPart getDropTargetEditPart(ModelElementDropRequest request) {
        GmCompositeNode gmModel = (GmCompositeNode)this.getHost().getModel();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement droppedElement = iElementArray[n2];
            if (!(gmModel.canUnmask(droppedElement) || this.isSmartPartNodeTarget(droppedElement, request) || this.isSmartCollabUseNodeTarget(droppedElement, request))) {
                return null;
            }
            ++n2;
        }
        return this.getHost();
    }

    protected Command getDropCommand(ModelElementDropRequest request) {
        CompoundCommand command = new CompoundCommand();
        Point dropLocation = request.getDropLocation();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement toUnmask = iElementArray[n2];
            if (this.isSmartPartNodeTarget(toUnmask, request)) {
                command.add(this.getSmartObjectNodeDropCommand(dropLocation, toUnmask));
            } else if (this.isSmartCollabUseNodeTarget(toUnmask, request)) {
                command.add(this.getSmartCreateCollabUseCommand(dropLocation, toUnmask));
            } else if (toUnmask != null) {
                ModelElementDropRequest subReq = new ModelElementDropRequest();
                subReq.setDroppedElements(new IElement[]{toUnmask});
                subReq.setExtendedData(request.getExtendedData());
                subReq.setLocation(dropLocation);
                subReq.isSmart(request.isSmart());
                command.add(super.getDropCommand(subReq));
            }
            dropLocation = dropLocation.getTranslated(20, 20);
            ++n2;
        }
        return command;
    }

    private Command getSmartObjectNodeDropCommand(Point dropLocation, IElement toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        IClassifier owner = (IClassifier)gmModel.getRelatedIElement();
        return new SmartCreatePartCommand(dropLocation, toUnmask, this.getHost(), (IElement)owner);
    }

    private boolean isSmartPartNodeTarget(IElement element, ModelElementDropRequest request) {
        if (!request.isSmart()) {
            return false;
        }
        if (element instanceof IPort) {
            return false;
        }
        GmModel gmModel = (GmModel)this.getHost().getModel();
        IClassifier owner = (IClassifier)gmModel.getRelatedIElement();
        return !owner.equals((Object)element.getCompositionOwner()) && (element instanceof IAssociationEnd || element instanceof IAttribute || element instanceof IInstance || element instanceof INameSpace || element instanceof IParameter);
    }

    private Command getSmartCreateCollabUseCommand(Point dropLocation, IElement toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        IClassifier owner = (IClassifier)gmModel.getRelatedIElement();
        return new SmartCreateCollabUseCommand(dropLocation, toUnmask, this.getHost(), (IElement)owner);
    }

    private boolean isSmartCollabUseNodeTarget(IElement element, ModelElementDropRequest request) {
        if (!request.isSmart()) {
            return false;
        }
        GmModel gmModel = (GmModel)this.getHost().getModel();
        IClassifier owner = (IClassifier)gmModel.getRelatedIElement();
        return !owner.equals((Object)element.getCompositionOwner()) && element instanceof ICollaboration;
    }
}

