/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.classifier;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.helpers.UnmaskHelper;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class SmartCreatePartCommand
extends Command {
    private IElement parentElement;
    private IElement toUnmask;
    private Point location;
    private EditPart parentEditPart;
    private EditPartViewer viewer;

    public SmartCreatePartCommand(Point dropLocation, IElement toUnmask, EditPart parentEditPart, IElement parentElement) {
        this.location = dropLocation;
        this.toUnmask = toUnmask;
        this.parentEditPart = parentEditPart;
        this.parentElement = parentElement;
        this.viewer = parentEditPart.getViewer();
    }

    public boolean canExecute() {
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)gmDiagram)) {
            return false;
        }
        return this.parentElement != null && this.parentElement.isValid() && this.parentElement.getElementStatus().isModifiable();
    }

    public void execute() {
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IModelFactory factory = gmDiagram.getModelFactory();
        IBindableInstance instanceNode = factory.createBindableInstance();
        String effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)instanceNode);
        if (effectiveDependency == null || effectiveDependency.isEmpty()) {
            throw new IllegalStateException("Cannot find a composition dependency to attach " + instanceNode.toString() + " to " + this.parentElement.toString());
        }
        Meta meta = new Meta(this.parentElement);
        meta.appendToDependency(effectiveDependency, (IElement)instanceNode);
        Collection ports = null;
        if (this.toUnmask instanceof IInstance) {
            instanceNode.setRepresentedFeature((IModelElement)((IInstance)this.toUnmask));
        } else if (this.toUnmask instanceof IAttribute) {
            instanceNode.setRepresentedFeature((IModelElement)((IAttribute)this.toUnmask));
        } else if (this.toUnmask instanceof IAssociationEnd) {
            instanceNode.setRepresentedFeature((IModelElement)((IAssociationEnd)this.toUnmask));
        } else if (this.toUnmask instanceof IClassifier) {
            instanceNode.setBase((INameSpace)this.toUnmask);
            ports = this.createPorts(instanceNode);
        } else if (this.toUnmask instanceof INameSpace) {
            instanceNode.setBase((INameSpace)this.toUnmask);
        } else if (this.toUnmask instanceof IModelElement) {
            instanceNode.setRepresentedFeature((IModelElement)this.toUnmask);
        }
        IElementInitializer elementInitializer = gmDiagram.getElementInitializer();
        elementInitializer.initialize((IElement)instanceNode, null);
        this.unmaskElement((IElement)instanceNode);
        if (ports != null && ports.size() > 0) {
            ((GraphicalEditPart)this.parentEditPart).getFigure().getUpdateManager().performValidation();
            this.location.translate(100, 10);
            Command cmd = UnmaskHelper.getUnmaskCommand((EditPartViewer)this.viewer, (Collection)ports, (Point)this.location);
            if (cmd != null && cmd.canExecute()) {
                cmd.execute();
            }
        }
    }

    private Collection<IPort> createPorts(IBindableInstance part) {
        IClassifier type = (IClassifier)part.getBase();
        ArrayList<IPort> ret = new ArrayList<IPort>(type.cardInternalStructure());
        for (IBindableInstance typePart : type.getInternalStructure()) {
            if (!(typePart instanceof IPort)) continue;
            IPort partPort = (IPort)ModelServices.clone((IElement)typePart);
            part.addPart((IBindableInstance)partPort);
            partPort.setRepresentedFeature((IModelElement)typePart);
            ret.add(partPort);
        }
        return ret;
    }

    private void unmaskElement(IElement el) {
        ModelioCreationContext gmCreationContext = new ModelioCreationContext(el);
        CreateRequest creationRequest = new CreateRequest();
        creationRequest.setLocation(this.location);
        creationRequest.setSize(new Dimension(-1, -1));
        creationRequest.setFactory((CreationFactory)gmCreationContext);
        Command cmd = this.parentEditPart.getTargetEditPart((Request)creationRequest).getCommand((Request)creationRequest);
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }
}

