/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.collab;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.diagram.editor.statik.elements.classifier.SmartCreateCollabUseCommand;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class CollaborationElementDropEditPolicy
extends DefaultElementDropEditPolicy {
    protected EditPart getDropTargetEditPart(ModelElementDropRequest request) {
        GmCompositeNode gmModel = (GmCompositeNode)this.getHost().getModel();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement droppedElement = iElementArray[n2];
            if (!gmModel.canUnmask(droppedElement) && !this.isSmartCollabUseNodeTarget(droppedElement, request)) {
                return null;
            }
            ++n2;
        }
        return this.getHost();
    }

    protected Command getDropCommand(ModelElementDropRequest request) {
        CompoundCommand command = new CompoundCommand();
        Point dropLocation = request.getDropLocation();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement toUnmask = iElementArray[n2];
            if (this.isSmartCollabUseNodeTarget(toUnmask, request)) {
                command.add(this.getSmartCreateCollabUseCommand(dropLocation, toUnmask));
            } else if (toUnmask != null) {
                this.createSubRequest(request, command, dropLocation, toUnmask);
            }
            dropLocation = dropLocation.getTranslated(20, 20);
            ++n2;
        }
        return command;
    }

    private Command getSmartCreateCollabUseCommand(Point dropLocation, IElement toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        ICollaboration owner = (ICollaboration)gmModel.getRelatedIElement();
        return new SmartCreateCollabUseCommand(dropLocation, toUnmask, this.getHost(), (IElement)owner);
    }

    private boolean isSmartCollabUseNodeTarget(IElement element, ModelElementDropRequest request) {
        if (!request.isSmart()) {
            return false;
        }
        return element instanceof ICollaboration;
    }

    private void createSubRequest(ModelElementDropRequest request, CompoundCommand command, Point dropLocation, IElement toUnmask) {
        ModelElementDropRequest subReq = new ModelElementDropRequest();
        subReq.setDroppedElements(new IElement[]{toUnmask});
        subReq.setExtendedData(request.getExtendedData());
        subReq.setLocation(dropLocation);
        subReq.isSmart(request.isSmart());
        command.add(super.getDropCommand(subReq));
    }
}

