/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.enumliteral;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IEnumeration;
import com.modeliosoft.modelio.api.model.uml.statik.IEnumerationLiteral;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.statik.elements.enumeration.EnumStructuredStyleKeys;
import com.modeliosoft.modelio.diagram.editor.statik.elements.enumliteral.GmEnumLitteral;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.group.GmGroup;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;

public class GmEnumLitteralGroup
extends GmGroup {
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmEnumLitteralGroup() {
    }

    public GmEnumLitteralGroup(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return IEnumerationLiteral.class.isAssignableFrom(type);
    }

    public IEnumeration getRelatedIElement() {
        return (IEnumeration)super.getRelatedIElement();
    }

    public boolean isVisible() {
        return (Boolean)this.getStyle().getProperty(EnumStructuredStyleKeys.LITGROUPVISIBLE) != false && this.getParent().getRepresentationMode().equals((Object)StyleKey.RepresentationMode.STRUCTURED);
    }

    public void obElementAdded(IElement movedEl) {
        this.refreshFromObModel();
    }

    public void refreshFromObModel() {
        super.refreshFromObModel();
        IEnumeration classifier = this.getRelatedIElement();
        if (classifier != null && classifier.isValid()) {
            for (IEnumerationLiteral part : classifier.getValue()) {
                if (this.getChild(new ObRef((IElement)part)) != null) continue;
                this.getDiagram().unmask((GmCompositeNode)this, (IElement)part, null);
            }
        }
    }

    public void styleChanged(StyleKey property, Object newValue) {
        if (property == EnumStructuredStyleKeys.LITGROUPVISIBLE) {
            this.fireVisibilityChanged();
        } else {
            super.styleChanged(property, newValue);
        }
    }

    public void styleChanged(IStyle style) {
        this.refreshFromObModel();
        this.fireVisibilityChanged();
        super.styleChanged(style);
    }

    protected void doSetVisible(boolean visible) {
        StyleKey key;
        this.getStyle().setProperty(EnumStructuredStyleKeys.LITGROUPVISIBLE, (Object)visible);
        if (visible && (key = this.getStyleKey(MetaKey.REPMODE)) != null) {
            this.getParent().getStyle().setProperty(key, (Object)StyleKey.RepresentationMode.STRUCTURED);
        }
    }

    protected boolean isValidElement(IElement el) {
        if (!(el instanceof IEnumerationLiteral) || !el.isValid()) {
            return false;
        }
        return el.getCompositionOwner().equals((Object)this.getRelatedIElement());
    }

    protected void updateHiddenFeatures() {
    }

    public boolean canContain(Class<? extends GmNodeModel> nodeClass) {
        return GmEnumLitteral.class.isAssignableFrom(nodeClass);
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmEnumLitteralGroup.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmEnumLitteralGroup.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }
}

