/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.informationconveyed;

import com.modeliosoft.modelio.api.model.uml.information.IInformationFlow;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.statik.elements.informationitem.GmInformationItemLabel;
import com.modeliosoft.modelio.diagram.editor.statik.elements.namespacelabel.GmNameSpaceLabel;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.group.GmGroup;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;

public class GmConveyedClassifiersGroup
extends GmGroup {
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmConveyedClassifiersGroup() {
    }

    public GmConveyedClassifiersGroup(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public boolean canContain(Class<? extends GmNodeModel> nodeClass) {
        return GmInformationItemLabel.class.isAssignableFrom(nodeClass) || GmNameSpaceLabel.class.isAssignableFrom(nodeClass);
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return IClassifier.class.isAssignableFrom(type);
    }

    public IInformationFlow getRelatedIElement() {
        return (IInformationFlow)super.getRelatedIElement();
    }

    public boolean isVisible() {
        return (Boolean)this.getStyle().getProperty(this.getViewModeStyleKey());
    }

    public void refreshFromObModel() {
        super.refreshFromObModel();
        IInformationFlow flow = this.getRelatedIElement();
        if (flow != null && flow.isValid()) {
            ObList conveyedClassifiers = flow.getConveyed();
            for (GmNodeModel c : this.getChildren()) {
                if (this.isValidElement(c.getRelatedIElement())) continue;
                c.delete();
            }
            for (IClassifier part : conveyedClassifiers) {
                if (this.getChild(new ObRef((IElement)part)) != null) continue;
                this.getDiagram().unmask((GmCompositeNode)this, (IElement)part, null);
            }
        }
    }

    public void styleChanged(StyleKey property, Object newValue) {
        if (property == this.getViewModeStyleKey()) {
            this.fireVisibilityChanged();
        } else {
            super.styleChanged(property, newValue);
        }
    }

    public void styleChanged(IStyle style) {
        this.refreshFromObModel();
        this.fireVisibilityChanged();
        super.styleChanged(style);
    }

    protected void doSetVisible(boolean visible) {
        this.getStyle().setProperty(this.getViewModeStyleKey(), (Object)visible);
    }

    protected boolean isValidElement(IElement el) {
        if (!(el instanceof IClassifier) || !el.isValid()) {
            return false;
        }
        return this.getRelatedIElement().getConveyed().contains((Object)el);
    }

    protected void updateHiddenFeatures() {
    }

    private StyleKey getViewModeStyleKey() {
        return this.getStyleKeyStrict(MetaKey.InformationItemGroup.INFSHOWGROUP);
    }

    public void obElementsUpdated() {
        this.refreshFromObModel();
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmConveyedClassifiersGroup.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmConveyedClassifiersGroup.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }
}

