/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.instance;

import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;

/*
 * Exception performing whole class analysis ignored.
 */
public class InstanceSymbolProvider {
    private InstanceSymbolProvider() {
    }

    public static String computeSimpleLabel(IInstance c) {
        StringBuilder s = new StringBuilder(60);
        String name = c.getName();
        s.append(name);
        InstanceSymbolProvider.computeType((IInstance)c, (StringBuilder)s);
        InstanceSymbolProvider.computeCard((IInstance)c, (StringBuilder)s);
        return s.toString();
    }

    private static void computeCard(IInstance c, StringBuilder s) {
        String min = c.getMultiplicityMin();
        String max = c.getMultiplicityMax();
        if (min.isEmpty() && max.isEmpty()) {
            return;
        }
        if (min.equals("1") && max.equals("1")) {
            return;
        }
        if (min.equals("0") && max.equals("*")) {
            s.append("[*]");
        } else {
            s.append("[");
            s.append(min);
            s.append("..");
            s.append(max);
            s.append("]");
        }
    }

    public static String computeFullQualifiedLabel(IInstance c) {
        StringBuilder s = new StringBuilder(100);
        IElement parent = c.getCompositionOwner();
        while (parent != null && !InstanceSymbolProvider.isRoot((IElement)parent)) {
            s.insert(0, '.');
            s.insert(0, parent.getName());
            parent = parent.getCompositionOwner();
        }
        s.append(c.getName());
        InstanceSymbolProvider.computeType((IInstance)c, (StringBuilder)s);
        InstanceSymbolProvider.computeCard((IInstance)c, (StringBuilder)s);
        return s.toString();
    }

    public static String computeQualifiedLabel(IInstance c) {
        StringBuilder s = new StringBuilder(100);
        IElement parent = c.getCompositionOwner();
        while (parent != null && parent instanceof IInstance) {
            s.insert(0, '.');
            s.insert(0, parent.getName());
            parent = parent.getCompositionOwner();
        }
        s.append(c.getName());
        InstanceSymbolProvider.computeType((IInstance)c, (StringBuilder)s);
        InstanceSymbolProvider.computeCard((IInstance)c, (StringBuilder)s);
        return s.toString();
    }

    private static boolean isRoot(IElement el) {
        if (el instanceof IProject) {
            return true;
        }
        IElement parent = el.getCompositionOwner();
        return parent == null || parent instanceof IProject;
    }

    private static void computeType(IInstance c, StringBuilder s) {
        INameSpace type = c.getBase();
        s.append(" : ");
        if (type != null) {
            s.append(type.getName());
        }
    }
}

