/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.instanceinternalstructure;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.statik.elements.instance.GmInstanceStructuredStyleKeys;
import com.modeliosoft.modelio.diagram.editor.statik.elements.instanceinternalstructure.GmInstanceInternalStructure;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.group.GmGroup;
import com.modeliosoft.modelio.diagram.elements.common.label.base.GmElementLabel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;

public class GmInstanceInternalStructureGroup
extends GmGroup {
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmInstanceInternalStructureGroup(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
        this.refreshFromObModel();
    }

    public GmInstanceInternalStructureGroup() {
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return IBindableInstance.class.isAssignableFrom(type);
    }

    public boolean isVisible() {
        if (this.getParent().getRepresentationMode().equals((Object)StyleKey.RepresentationMode.STRUCTURED)) {
            StyleKey.InternalsViewMode v = (StyleKey.InternalsViewMode)this.getStyle().getProperty(GmInstanceStructuredStyleKeys.INTERNALSVIEWMODE);
            return v == StyleKey.InternalsViewMode.LIST;
        }
        return false;
    }

    public void obElementAdded(IElement movedEl) {
        this.refreshFromObModel();
    }

    public void obElementsUpdated() {
        this.refreshFromObModel();
    }

    public void refreshFromObModel() {
        Boolean autoShow;
        super.refreshFromObModel();
        IInstance instance = (IInstance)this.getRelatedIElement();
        if (instance != null && instance.isValid() && (autoShow = (Boolean)this.getStyle().getProperty(GmInstanceStructuredStyleKeys.InternalStructure.AUTOUNMASK)).booleanValue()) {
            for (IBindableInstance part : instance.getPart()) {
                if (part instanceof IPort || this.getChild(new ObRef((IElement)part)) != null) continue;
                this.getDiagram().unmask((GmCompositeNode)this, (IElement)part, null);
            }
        }
    }

    public void styleChanged(IStyle style) {
        this.fireVisibilityChanged();
        super.styleChanged(style);
    }

    public void styleChanged(StyleKey property, Object newValue) {
        if (property == GmInstanceStructuredStyleKeys.INTERNALSVIEWMODE) {
            this.fireVisibilityChanged();
        } else {
            super.styleChanged(property, newValue);
        }
    }

    protected void doSetVisible(boolean visible) {
        if (visible) {
            this.getStyle().setProperty(GmInstanceStructuredStyleKeys.INTERNALSVIEWMODE, (Object)StyleKey.InternalsViewMode.LIST);
            ((GmInstanceInternalStructure)this.getParent()).setVisible(true);
        } else {
            this.getStyle().setProperty(GmInstanceStructuredStyleKeys.INTERNALSVIEWMODE, (Object)StyleKey.InternalsViewMode.NONE);
        }
    }

    protected boolean isValidElement(IElement el) {
        if (!(el instanceof IInstance) || !el.isValid()) {
            return false;
        }
        return el.getCompositionOwner().equals((Object)this.getRelatedIElement());
    }

    protected void updateHiddenFeatures() {
        IInstance instance = (IInstance)this.getRelatedIElement();
        if (instance != null && instance.isValid()) {
            Boolean autoShow = (Boolean)this.getStyle().getProperty(GmInstanceStructuredStyleKeys.InternalStructure.AUTOUNMASK);
            boolean hasHiddenFeature = false;
            if (!autoShow.booleanValue()) {
                hasHiddenFeature = instance.getPart().size() != this.getChildren().size();
            }
            this.setHiddenFeature(hasHiddenFeature);
        }
    }

    public boolean canContain(Class<? extends GmNodeModel> nodeClass) {
        return GmElementLabel.class.isAssignableFrom(nodeClass);
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmInstanceInternalStructureGroup.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmInstanceInternalStructureGroup.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }
}

