/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.instancelink;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.ILinkEnd;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.statik.elements.instancelink.GmLinkRoleCardinalityLabel;
import com.modeliosoft.modelio.diagram.editor.statik.elements.instancelink.GmLinkRoleNameLabel;
import com.modeliosoft.modelio.diagram.editor.statik.elements.instancelink.InstanceLinkStructuredStyleKeys;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.header.GmDefaultModelElementHeader;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.GmFractionalConnectionLocator;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.IGmLocator;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.umlcommon.informationflowgroup.GmInfoFlowsGroup;
import com.modeliosoft.modelio.diagram.elements.umlcommon.informationflowgroup.GmInformationFlowArrow;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GmInstanceLink
extends GmLink {
    private ILinkEnd role;
    private static final InstanceLinkStructuredStyleKeys STRUCTURED_KEYS = new InstanceLinkStructuredStyleKeys();
    private boolean fromNavigable;
    private boolean toNavigable;
    private ObRef roleRef = null;
    private ILink link;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmInstanceLink() {
    }

    public GmInstanceLink(GmAbstractDiagram diagram, ILinkEnd role, ObRef roleRef, ObRef associationRef) {
        super(diagram, associationRef);
        this.role = role;
        this.roleRef = roleRef;
        if (role != null) {
            this.link = role.getLinkNode();
            ILinkEnd oppositeRole = this.getOppositeRole();
            if (oppositeRole != null) {
                this.fromNavigable = oppositeRole.isNavigable();
            }
            this.toNavigable = this.role.isNavigable();
            ObRef oppositeRoleRef = new ObRef((IElement)oppositeRole);
            this.addExtension("sourceNW", (GmNodeModel)new GmLinkRoleNameLabel(diagram, oppositeRole, oppositeRoleRef));
            this.addExtension("SourceSE", (GmNodeModel)new GmLinkRoleCardinalityLabel(diagram, oppositeRole, oppositeRoleRef));
            GmFractionalConnectionLocator constraint = new GmFractionalConnectionLocator(0.25, 0, -10);
            this.addExtension((GmNodeModel)new GmInfoFlowsGroup(diagram, oppositeRoleRef), (IGmLocator)constraint);
            constraint = new GmFractionalConnectionLocator(0.25, 0, 0, false);
            this.addExtension((GmNodeModel)new GmInformationFlowArrow(diagram, oppositeRoleRef), (IGmLocator)constraint);
            this.addExtension("TargetNW", (GmNodeModel)new GmLinkRoleNameLabel(diagram, this.role, roleRef));
            this.addExtension("TargetSE", (GmNodeModel)new GmLinkRoleCardinalityLabel(diagram, this.role, roleRef));
            constraint = new GmFractionalConnectionLocator(0.75, 0, -10);
            this.addExtension((GmNodeModel)new GmInfoFlowsGroup(diagram, roleRef), (IGmLocator)constraint);
            constraint = new GmFractionalConnectionLocator(0.75, 0, 0, true);
            this.addExtension((GmNodeModel)new GmInformationFlowArrow(diagram, roleRef), (IGmLocator)constraint);
            this.addExtension("MiddleSE", (GmNodeModel)new GmDefaultModelElementHeader(diagram, associationRef));
        }
    }

    public ILink getRelatedIElement() {
        return this.link;
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        return STRUCTURED_KEYS.getStyleKey(metakey);
    }

    public List<StyleKey> getStyleKeys() {
        return STRUCTURED_KEYS.getStyleKeys();
    }

    public void refreshFromObModel() {
        super.refreshFromObModel();
        ILinkEnd opposite = this.getOppositeRole();
        if (opposite != null && opposite.isValid()) {
            this.fromNavigable = opposite.isNavigable();
        }
        if (this.role != null && this.role.isValid()) {
            this.toNavigable = this.role.isNavigable();
        }
        this.firePropertyChange("LayoutData", null, (Object)this);
    }

    ILinkEnd getOppositeRole() {
        if (this.role == null || !this.role.isValid()) {
            return null;
        }
        List oppositeEnds = this.getOppositeEnds(this.role);
        if (oppositeEnds.isEmpty()) {
            return null;
        }
        return (ILinkEnd)oppositeEnds.get(0);
    }

    public boolean isFromNavigable() {
        return this.fromNavigable;
    }

    public boolean isToNavigable() {
        return this.toNavigable;
    }

    public IInstance getFromElement() {
        return this.role.getLinked();
    }

    public IInstance getToElement() {
        return ((ILinkEnd)this.getOppositeEnds(this.role).get(0)).getLinked();
    }

    protected void readLink(IDiagramReader in) {
        this.roleRef = (ObRef)in.readProperty("representedRole");
        this.role = (ILinkEnd)this.resolveRef(this.roleRef);
        this.link = (ILink)this.resolveRef(this.getRepresentedRef());
        if (this.role != null) {
            ILinkEnd opposite = this.getOppositeRole();
            this.fromNavigable = opposite != null ? opposite.isNavigable() : false;
            this.toNavigable = this.role.isNavigable();
        } else {
            this.fromNavigable = false;
            this.toNavigable = true;
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("representedRole", this.roleRef);
        if (false) {
            out.writeProperty("GmInstanceLink.version", (Object)0);
        }
    }

    private List<ILinkEnd> getOppositeEnds(ILinkEnd aRole) {
        ArrayList<ILinkEnd> ret = new ArrayList<ILinkEnd>((Collection<ILinkEnd>)aRole.getLinkNode().getConnection());
        ret.remove(aRole);
        return ret;
    }

    public ILinkEnd getRepresentedRole() {
        return this.role;
    }

    public IElement getRepresentedIElement() {
        return this.link;
    }

    public int getMajorVersion() {
        return 0;
    }
}

