/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.internalstructure;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaborationUse;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.statik.elements.internalstructure.GmInternalStructure;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.group.GmGroup;
import com.modeliosoft.modelio.diagram.elements.common.label.base.GmElementLabel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;

public class GmInternalStructureGroup
extends GmGroup {
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmInternalStructureGroup(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public GmInternalStructureGroup() {
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return IInstance.class.isAssignableFrom(type) && !IPort.class.isAssignableFrom(type) || ICollaborationUse.class.isAssignableFrom(type);
    }

    public boolean isVisible() {
        GmInternalStructure parent = (GmInternalStructure)this.getParent();
        if (parent.getRepresentationMode().equals((Object)StyleKey.RepresentationMode.STRUCTURED) && parent.isVisible()) {
            StyleKey viewModeStyleKey = this.getViewModeStyleKey();
            if (viewModeStyleKey == null) {
                return false;
            }
            StyleKey.InternalsViewMode v = (StyleKey.InternalsViewMode)this.getStyle().getProperty(viewModeStyleKey);
            return v == StyleKey.InternalsViewMode.LIST;
        }
        return false;
    }

    public void obElementAdded(IElement movedEl) {
        this.refreshFromObModel();
    }

    public void obElementsUpdated() {
        this.refreshFromObModel();
    }

    public void refreshFromObModel() {
        super.refreshFromObModel();
        IElement relatedIElement = this.getRelatedIElement();
        if (relatedIElement == null || !relatedIElement.isValid()) {
            return;
        }
        StyleKey styleKey = this.getStyleKey(MetaKey.InternalGroup.INTAUTOUNMASK);
        if (styleKey == null) {
            return;
        }
        Boolean mode = (Boolean)this.getStyle().getProperty(styleKey);
        if (mode.booleanValue()) {
            if (relatedIElement instanceof IClassifier) {
                IClassifier classifier = (IClassifier)relatedIElement;
                for (IBindableInstance part : classifier.getInternalStructure()) {
                    if (part instanceof IPort || this.getChild(new ObRef((IElement)part)) != null) continue;
                    this.getDiagram().unmask((GmCompositeNode)this, (IElement)part, null);
                }
            }
            if (relatedIElement instanceof INameSpace) {
                INameSpace namespace = (INameSpace)relatedIElement;
                for (IBindableInstance part : namespace.getDeclared()) {
                    if (part instanceof IPort || this.getChild(new ObRef((IElement)part)) != null) continue;
                    this.getDiagram().unmask((GmCompositeNode)this, (IElement)part, null);
                }
                for (IBindableInstance part : namespace.getOwnedCollaborationUse()) {
                    if (this.getChild(new ObRef((IElement)part)) != null) continue;
                    this.getDiagram().unmask((GmCompositeNode)this, (IElement)part, null);
                }
            }
        }
    }

    public void styleChanged(IStyle style) {
        this.fireVisibilityChanged();
        super.styleChanged(style);
    }

    public void styleChanged(StyleKey property, Object newValue) {
        if (property == this.getViewModeStyleKey()) {
            this.fireVisibilityChanged();
        } else {
            super.styleChanged(property, newValue);
        }
    }

    protected void doSetVisible(boolean visible) {
        if (visible) {
            this.getStyle().setProperty(this.getViewModeStyleKey(), (Object)StyleKey.InternalsViewMode.LIST);
            ((GmInternalStructure)this.getParent()).setVisible(true);
        } else {
            this.getStyle().setProperty(this.getViewModeStyleKey(), (Object)StyleKey.InternalsViewMode.NONE);
        }
    }

    protected boolean isValidElement(IElement el) {
        if (!el.isValid() || !this.canCreate(el.getClass())) {
            return false;
        }
        return el.getCompositionOwner().equals((Object)this.getRelatedIElement());
    }

    protected void updateHiddenFeatures() {
        IElement relatedIElement = this.getRelatedIElement();
        if (!relatedIElement.isValid()) {
            return;
        }
        if (relatedIElement instanceof IClassifier) {
            IClassifier classifier = (IClassifier)relatedIElement;
            Boolean mode = (Boolean)this.getStyle().getProperty(this.getStyleKeyStrict(MetaKey.InternalGroup.INTAUTOUNMASK));
            boolean hasHiddenFeature = false;
            if (!mode.booleanValue()) {
                hasHiddenFeature = classifier.cardInternalStructure() + classifier.cardDeclared() + classifier.cardOwnedCollaborationUse() != this.getChildren().size();
            }
            this.setHiddenFeature(hasHiddenFeature);
        } else if (relatedIElement instanceof INameSpace) {
            INameSpace namespace = (INameSpace)relatedIElement;
            Boolean mode = (Boolean)this.getStyle().getProperty(this.getStyleKeyStrict(MetaKey.InternalGroup.INTAUTOUNMASK));
            boolean hasHiddenFeature = false;
            if (!mode.booleanValue()) {
                hasHiddenFeature = namespace.cardDeclared() + namespace.cardOwnedCollaborationUse() != this.getChildren().size();
            }
            this.setHiddenFeature(hasHiddenFeature);
        }
    }

    public boolean canContain(Class<? extends GmNodeModel> nodeClass) {
        return GmElementLabel.class.isAssignableFrom(nodeClass);
    }

    private StyleKey getViewModeStyleKey() {
        return this.getStyleKey(MetaKey.InternalGroup.INTVIEWMODE);
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmInternalStructureGroup.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmInternalStructureGroup.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }
}

