/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.namespacinglink;

import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;

public class CircleDeco
extends GradientFigure
implements RotatableDecoration {
    private static final int CIRCLE_OFFSET = 4;
    private Point location = new Point();
    private Transform transform = new Transform();
    private static final PrecisionPoint tmp = new PrecisionPoint();

    public CircleDeco() {
        this.setSize(8, 8);
    }

    public void setReferencePoint(Point ref) {
        Point pt = Point.SINGLETON;
        pt.setLocation(ref);
        pt.negate().translate(this.location);
        this.transform.setRotation(Math.atan2(pt.y, pt.x));
    }

    public void setLocation(Point p) {
        this.location.setLocation(p);
        this.transform.setTranslation((double)p.x, (double)p.y);
    }

    protected void paintFigure(Graphics graphics) {
        tmp.setLocation(-4, 0);
        tmp.setLocation(this.transform.getTransformed((Point)tmp));
        graphics.setForegroundColor(this.getLineColor());
        graphics.setBackgroundColor(this.getFillColor());
        graphics.setClip(new Rectangle(tmp.x() - 5, tmp.y() - 5, 10, 10));
        graphics.fillArc(tmp.x() - 4, tmp.y() - 4, 9, 9, 0, 360);
    }

    protected void paintBorder(Graphics graphics) {
        tmp.setLocation(-4, 0);
        tmp.setLocation(this.transform.getTransformed((Point)tmp));
        graphics.setForegroundColor(this.getLineColor());
        graphics.setBackgroundColor(this.getFillColor());
        graphics.setClip(new Rectangle(tmp.x() - 5, tmp.y() - 5, 10, 10));
        graphics.drawArc(tmp.x() - 4, tmp.y() - 4, 8, 8, 0, 360);
        graphics.drawLine(tmp.x() - 4, tmp.y(), tmp.x() + 4, tmp.y());
        graphics.drawLine(tmp.x(), tmp.y() - 4, tmp.x(), tmp.y() + 4);
    }

    public Rectangle getBounds() {
        tmp.setLocation(-10, 0);
        tmp.setLocation(this.transform.getTransformed((Point)tmp));
        return new Rectangle(tmp.x() - 5, tmp.y() - 5, 10, 10);
    }
}

