/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.narylink;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.ILinkEnd;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.helpers.UnmaskHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;

public class CreateNLinkCommand
extends Command {
    private ModelioLinkCreationContext context;
    private List<IGmLinkable> sourceModels;
    private Rectangle layoutConstraint;
    private GmCompositeNode parentNode;
    private EditPart editPart;

    public CreateNLinkCommand(EditPart editPart, List<IGmLinkable> sourceModels, GmCompositeNode parentNode, ModelioLinkCreationContext context, Rectangle constraint) {
        this.editPart = editPart;
        this.sourceModels = sourceModels;
        this.parentNode = parentNode;
        this.context = context;
        this.layoutConstraint = constraint;
    }

    public boolean canExecute() {
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.parentNode.getDiagram())) {
            return false;
        }
        for (IGmLinkable sourceModel : this.sourceModels) {
            if (AuthHelper.canModify((IElement)sourceModel.getRelatedIElement())) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        ILink newAssoc = (ILink)this.context.getElementToUnmask();
        ArrayList<ILinkEnd> createdAssocs = new ArrayList<ILinkEnd>(this.sourceModels.size());
        if (newAssoc == null) {
            IElementInitializer elementInitializer = diagram.getElementInitializer();
            IModelFactory modelFactory = diagram.getModelFactory();
            newAssoc = modelFactory.createLink();
            for (IGmLinkable sourceModel : this.sourceModels) {
                IInstance el = (IInstance)sourceModel.getRelatedIElement();
                ILinkEnd role = modelFactory.createLinkEnd();
                role.setLinked(el);
                role.setLinkNode(newAssoc);
                role.setNavigable(true);
                createdAssocs.add(role);
                elementInitializer.initialize((IElement)role, this.context.getProperties());
            }
            if (this.context.getStereotype() != null) {
                newAssoc.addExtension(this.context.getStereotype());
            }
            elementInitializer.initialize((IElement)newAssoc, this.context.getProperties());
        }
        diagram.unmask(this.parentNode, (IElement)newAssoc, (Object)this.layoutConstraint);
        EditPartViewer viewer = this.editPart.getViewer();
        for (ILinkEnd r : createdAssocs) {
            Command cmd = UnmaskHelper.getUnmaskCommand((EditPartViewer)viewer, (IElement)r, (Point)this.layoutConstraint.getCenter());
            cmd.execute();
        }
    }
}

