/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.narylink;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.ILinkEnd;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.statik.elements.narylink.GmNLinkEndLink;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.UnmaskLinkCommand;
import com.modeliosoft.modelio.diagram.elements.core.figures.DiamondShaper;
import com.modeliosoft.modelio.diagram.elements.core.figures.IShaper;
import com.modeliosoft.modelio.diagram.elements.core.figures.ShapedBorderedFigure;
import com.modeliosoft.modelio.diagram.elements.core.link.DefaultCreateLinkEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.GmAbstractObject;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.SmallNodeNonResizeableEditPolicy;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;

public class NLinkNodeEditPart
extends GmNodeEditPart {
    private static final IShaper DIAMOND_SHAPE = new DiamondShaper();
    private static final Dimension DIAMOND_SIZE = new Dimension(15, 15);

    protected IFigure createFigure() {
        ShapedBorderedFigure fig = new ShapedBorderedFigure(DIAMOND_SHAPE);
        fig.setMinimumSize(DIAMOND_SIZE);
        fig.setPreferredSize(DIAMOND_SIZE);
        fig.setOpaque(true);
        this.refreshFromStyle((IFigure)fig, this.getModelStyle());
        return fig;
    }

    protected void refreshVisuals() {
        GmAbstractObject model = (GmAbstractObject)this.getModel();
        this.getFigure().getParent().setConstraint(this.getFigure(), model.getLayoutData());
    }

    public boolean isSelectable() {
        return false;
    }

    public SelectionEditPolicy getPreferredDragRolePolicy(String requestType) {
        return new SmallNodeNonResizeableEditPolicy();
    }

    protected void refreshFromStyle(IFigure aFigure, IStyle style) {
        GmNodeModel gmModel;
        StyleKey.RepresentationMode askedMode;
        if (aFigure instanceof ShapedBorderedFigure && ((askedMode = (gmModel = (GmNodeModel)this.getModel()).getRepresentationMode()) != StyleKey.RepresentationMode.IMAGE || !this.switchRepresentationMode())) {
            super.refreshFromStyle(aFigure, style);
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy((Object)"NodeEditPolicy", (EditPolicy)new DefaultCreateLinkEditPolicy());
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connectionPart) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("refresh branches")) {
            GmNodeModel gmModel = (GmNodeModel)this.getModel();
            List newbranches = this.getMissingBranches(gmModel);
            Point dropLocation = this.getFigure().getBounds().getBottomRight();
            this.getFigure().translateToAbsolute((Translatable)dropLocation);
            for (ILinkEnd b : newbranches) {
                this.createMissingLinkForElement(b, dropLocation);
                dropLocation.translate(5, 30);
            }
        } else if (evt.getPropertyName().equals("Link source")) {
            GmNodeModel gmModel = (GmNodeModel)this.getModel();
            if (evt.getNewValue() == null && !this.getMissingBranches(gmModel).isEmpty()) {
                this.deactivate();
                gmModel.getParentNode().delete();
                return;
            }
        }
        super.propertyChange(evt);
    }

    private List<ILinkEnd> getMissingBranches(GmNodeModel gmModel) {
        ILink element = (ILink)gmModel.getRelatedIElement();
        if (element == null || !element.isValid()) {
            return Collections.emptyList();
        }
        ArrayList<ILinkEnd> newbranches = new ArrayList<ILinkEnd>((Collection<ILinkEnd>)element.getConnection());
        List gmBranches = gmModel.getStartingLinks();
        for (IGmLink l : gmBranches) {
            newbranches.remove(l.getRelatedIElement());
        }
        return newbranches;
    }

    private void createMissingLinkForElement(ILinkEnd b, Point dropLocation) {
        GmNodeModel gmModel = (GmNodeModel)this.getModel();
        GmNLinkEndLink link = new GmNLinkEndLink(gmModel.getDiagram(), b, new ObRef((IElement)b));
        UnmaskLinkCommand cmd = new UnmaskLinkCommand((GmLink)link, (AbstractDiagramEditPart)this.getRoot().getContents(), dropLocation);
        cmd.execute();
    }
}

