/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.packaze;

import com.modeliosoft.modelio.diagram.editor.statik.elements.namespacinglink.GmCompositionLink;
import com.modeliosoft.modelio.diagram.editor.statik.elements.namespacinglink.redraw.RedrawCompositionLinkEditPolicy;
import com.modeliosoft.modelio.diagram.editor.statik.elements.packaze.GmPackage;
import com.modeliosoft.modelio.diagram.editor.statik.elements.packaze.GmPackagePrimaryNode;
import com.modeliosoft.modelio.diagram.elements.common.freezone.GmFreeZoneEditPart;
import com.modeliosoft.modelio.diagram.elements.common.header.ModelElementHeaderEditPart;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.LinkedNodeStartCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.link.DefaultCreateLinkEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.model.GmAbstractObject;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.umlcommon.constraint.ConstraintLinkEditPolicy;
import com.modeliosoft.modelio.diagram.elements.umlcommon.packaze.PackageFigure;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;

public class PackageEditPart
extends GmNodeEditPart {
    private static final int MARGIN = 20;

    protected void addChildVisual(EditPart child, int index) {
        IFigure childFigure = ((GraphicalEditPart)child).getFigure();
        if (child instanceof GmFreeZoneEditPart) {
            this.getPackageFigure().setContentsFigure(childFigure);
        } else if (child instanceof ModelElementHeaderEditPart) {
            this.getPackageFigure().setHeaderFigure(childFigure);
        } else {
            throw new IllegalArgumentException("Cannot add " + child.toString() + " child edit part to PackageEditPart");
        }
    }

    protected void removeChildVisual(EditPart child) {
        if (child instanceof GmFreeZoneEditPart) {
            this.getPackageFigure().setContentsFigure(null);
        } else if (child instanceof ModelElementHeaderEditPart) {
            this.getPackageFigure().setHeaderFigure(null);
        } else {
            throw new IllegalArgumentException("Cannot remove " + child.toString() + " child edit part from PackageEditPart");
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy((Object)"NodeEditPolicy", (EditPolicy)new DefaultCreateLinkEditPolicy());
        this.installEditPolicy((Object)"Linked node start", (EditPolicy)new LinkedNodeStartCreationEditPolicy());
        this.installEditPolicy((Object)"Multipoint First", (EditPolicy)new ConstraintLinkEditPolicy(false));
        this.installEditPolicy((Object)"RedrawCompositionLinkEditPolicy", (EditPolicy)new RedrawCompositionLinkEditPolicy());
    }

    protected IFigure createFigure() {
        PackageFigure figure1 = new PackageFigure();
        figure1.setPreferredSize(180, 140);
        this.refreshFromStyle((IFigure)figure1, this.getModelStyle());
        return figure1;
    }

    protected void refreshFromStyle(IFigure aFigure, IStyle style) {
        if (aFigure.getClass() == PackageFigure.class) {
            GmPackagePrimaryNode model = (GmPackagePrimaryNode)this.getModel();
            if (model.getRepresentationMode() == StyleKey.RepresentationMode.SIMPLE) {
                for (GmNodeModel child : model.getBody().getChildren()) {
                    child.setRoleInComposition("body content as satellite");
                    Rectangle constraint = (Rectangle)child.getLayoutData();
                    if (constraint.x() < 120 && constraint.y() < 70) {
                        constraint.setY(70);
                    }
                    model.getBody().removeChild(child);
                    model.getParentNode().addChild(child);
                    GmCompositionLink link = new GmCompositionLink(model.getDiagram(), model.getRepresentedRef());
                    model.addStartingLink((IGmLink)link);
                    child.addEndingLink((IGmLink)link);
                }
            }
            if (this.switchRepresentationMode()) {
                GmPackage gmPackage = (GmPackage)model.getParentNode();
                GmCompositeNode ancestor = gmPackage.getParentNode();
                int index = ancestor.getChildIndex((GmNodeModel)gmPackage);
                ancestor.removeChild((GmNodeModel)gmPackage);
                ancestor.addChild((GmNodeModel)gmPackage, index);
                return;
            }
        }
        super.refreshFromStyle(aFigure, style);
    }

    protected void refreshVisuals() {
        IFigure fig = this.getFigure();
        GmAbstractObject model = (GmAbstractObject)this.getModel();
        fig.getParent().setConstraint(fig, model.getLayoutData());
    }

    private PackageFigure getPackageFigure() {
        return (PackageFigure)this.getFigure();
    }

    public boolean isSelectable() {
        return false;
    }
}

