/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.requiredinterface;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IConnector;
import com.modeliosoft.modelio.api.model.uml.statik.IConnectorEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.api.model.uml.statik.IProvidedInterface;
import com.modeliosoft.modelio.api.model.uml.statik.IRequiredInterface;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.LinkServices;
import com.modeliosoft.modelio.diagram.editor.statik.elements.providedinterface.GmProvidedInterfaceLink;
import com.modeliosoft.modelio.diagram.editor.statik.elements.providedinterface.ProvidedInterfaceLinkEditPart;
import com.modeliosoft.modelio.diagram.editor.statik.elements.requiredinterface.GmLollipopConnection;
import com.modeliosoft.modelio.diagram.editor.statik.elements.requiredinterface.GmRequiredInterfaceLink;
import com.modeliosoft.modelio.diagram.editor.statik.elements.requiredinterface.RequiredInterfaceLinkEditPart;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class ConnectLollipopsCommand
extends Command {
    private RequiredInterfaceLinkEditPart reqEditPart;
    private ProvidedInterfaceLinkEditPart provEditPart;
    private Point location;

    public ConnectLollipopsCommand(RequiredInterfaceLinkEditPart reqEditPart, ProvidedInterfaceLinkEditPart provEditPart, Point location) {
        this.reqEditPart = reqEditPart;
        this.provEditPart = provEditPart;
        this.location = location;
    }

    public void execute() {
        GmRequiredInterfaceLink gmReq = (GmRequiredInterfaceLink)this.reqEditPart.getModel();
        GmProvidedInterfaceLink gmProv = (GmProvidedInterfaceLink)this.provEditPart.getModel();
        IRequiredInterface req = gmReq.getRelatedIElement();
        IProvidedInterface prov = gmProv.getRelatedIElement();
        IPort reqPort = req.getRequiring();
        IPort provPort = prov.getProviding();
        LinkServices.RequiredInterfaceService.removeTarget((IRequiredInterface)req);
        LinkServices.ProvidedInterfaceService.removeTarget((IProvidedInterface)prov);
        GmAbstractDiagram gmDiagram = gmReq.getDiagram();
        IModelFactory factory = gmDiagram.getModelFactory();
        IElementInitializer initer = gmProv.getDiagram().getElementInitializer();
        IConnector conn = factory.createConnector();
        IConnectorEnd reqConn = factory.createConnectorEnd();
        IConnectorEnd provConn = factory.createConnectorEnd();
        reqConn.setLinked((IInstance)reqPort);
        reqConn.setConsumer(req);
        reqConn.setLinkNode((ILink)conn);
        provConn.setLinked((IInstance)provPort);
        provConn.setLinkNode((ILink)conn);
        provConn.setProvider(prov);
        initer.initialize((IElement)reqConn);
        initer.initialize((IElement)provConn);
        initer.initialize((IElement)conn);
        GmLollipopConnection cnx = new GmLollipopConnection(gmDiagram, conn, new ObRef((IElement)conn));
        gmDiagram.addChild((GmNodeModel)cnx);
        Point pt = this.location.getCopy();
        IFigure targetFig = ((AbstractGraphicalEditPart)this.reqEditPart.getTarget()).getFigure();
        targetFig.translateToRelative((Translatable)pt);
        cnx.setLayoutData((Object)new Rectangle(pt.x, pt.y, -1, -1));
    }

    public boolean canExecute() {
        GmRequiredInterfaceLink gmReq = (GmRequiredInterfaceLink)this.reqEditPart.getModel();
        GmProvidedInterfaceLink gmProv = (GmProvidedInterfaceLink)this.provEditPart.getModel();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)gmProv.getDiagram())) {
            return false;
        }
        IRequiredInterface req = gmReq.getRelatedIElement();
        IProvidedInterface prov = gmProv.getRelatedIElement();
        IPort reqPort = req.getRequiring();
        IPort provPort = prov.getProviding();
        return AuthHelper.canModify((IElement)req) && AuthHelper.canModify((IElement)prov) && AuthHelper.canModify((IElement)reqPort) && AuthHelper.canModify((IElement)provPort);
    }
}

