/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.requiredinterface;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.linktovoid.CreateLinkToVoidCommand;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.CreateBendedConnectionRequest;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.ReconnectRequest;

public class CreateConnectedConnectionCommand
extends Command {
    private EditPart requiredInterfacePart;
    private Point location;
    private CreateConnectionRequest request;

    public CreateConnectedConnectionCommand(CreateConnectionRequest request, EditPart targetPart, Point location) {
        this.request = request;
        this.requiredInterfacePart = targetPart;
        this.location = location;
    }

    public void execute() {
        EditPart diagramEditPart = this.requiredInterfacePart.getViewer().getContents();
        CreateConnectionRequest r1 = this.getRequestCopy();
        r1.setTargetEditPart(diagramEditPart);
        CreateLinkToVoidCommand c1 = (CreateLinkToVoidCommand)diagramEditPart.getCommand((Request)r1);
        c1.execute();
        IElement createdProvidedInterface = c1.getCreatedElement();
        ConnectionEditPart provEditPart = (ConnectionEditPart)this.getEditPartFor(createdProvidedInterface);
        ReconnectRequest req = new ReconnectRequest((Object)"Link to void reconnection target");
        req.setConnectionEditPart(provEditPart);
        req.setTargetEditPart(this.requiredInterfacePart);
        req.setLocation(this.location);
        Command c2 = this.requiredInterfacePart.getCommand((Request)req);
        if (c2 != null && c2.canExecute()) {
            c2.execute();
        }
    }

    public boolean canExecute() {
        EditPart diagramEditPart = this.requiredInterfacePart.getViewer().getContents();
        CreateConnectionRequest r1 = this.getRequestCopy();
        r1.setTargetEditPart(diagramEditPart);
        CreateLinkToVoidCommand c1 = (CreateLinkToVoidCommand)diagramEditPart.getCommand((Request)r1);
        if (c1 == null || !c1.canExecute()) {
            return false;
        }
        GmModel tt = (GmModel)this.requiredInterfacePart.getModel();
        return AuthHelper.canModify((IElement)tt.getRelatedIElement());
    }

    private CreateConnectionRequest getRequestCopy() {
        if (this.request instanceof CreateBendedConnectionRequest) {
            CreateBendedConnectionRequest orig = (CreateBendedConnectionRequest)this.request;
            CreateBendedConnectionRequest ret = new CreateBendedConnectionRequest();
            ret.setExtendedData(orig.getExtendedData());
            ret.setFactory((CreationFactory)orig.getNewObject());
            ret.setLocation(orig.getLocation());
            ret.setSize(orig.getSize());
            ret.setSourceEditPart(orig.getSourceEditPart());
            ret.setStartCommand(orig.getStartCommand());
            ret.setTargetEditPart(orig.getTargetEditPart());
            ret.setType(orig.getType());
            ret.getData().setRoutingMode(orig.getData().getRoutingMode());
            ret.getData().setSrcPoint(orig.getData().getSrcPoint());
            for (Point p : orig.getData().getPath()) {
                ret.getData().getPath().add(p);
            }
            return ret;
        }
        CreateConnectionRequest ret = new CreateConnectionRequest();
        ret.setExtendedData(this.request.getExtendedData());
        ret.setFactory((CreationFactory)this.request.getNewObject());
        ret.setLocation(this.request.getLocation());
        ret.setSize(this.request.getSize());
        ret.setSourceEditPart(this.request.getSourceEditPart());
        ret.setStartCommand(this.request.getStartCommand());
        ret.setTargetEditPart(this.request.getTargetEditPart());
        ret.setType(this.request.getType());
        return ret;
    }

    private EditPart getEditPartFor(IElement element) {
        IGmObject gmModel = (IGmObject)this.requiredInterfacePart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        List models = gmDiagram.getAllGMRelatedTo(new ObRef(element));
        for (GmModel model : models) {
            EditPart editPart = (EditPart)this.requiredInterfacePart.getViewer().getEditPartRegistry().get(model);
            if (editPart == null) continue;
            return editPart;
        }
        return null;
    }
}

