/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.statik.elements.templateparameter;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.ITemplateParameter;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.label.modelelement.GmModelElementFlatHeader;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import java.util.Collections;
import java.util.List;

public class GmTemplateSignature
extends GmModelElementFlatHeader {
    private INameSpace related;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmTemplateSignature(GmAbstractDiagram diagram, INameSpace related, ObRef relatedRef) {
        super(diagram, relatedRef);
        this.related = related;
    }

    public GmTemplateSignature() {
    }

    public List<IStereotype> filterStereotypes(List<IStereotype> stereotypes) {
        return Collections.emptyList();
    }

    public List<ITaggedValue> filterTags(List<ITaggedValue> taggedValues) {
        return Collections.emptyList();
    }

    public IEditableText getEditableText() {
        return null;
    }

    protected String computeLabel() {
        StringBuilder s = new StringBuilder(50);
        for (ITemplateParameter t : this.related.getTemplate()) {
            if (s.length() > 0) {
                s.append(", ");
            }
            this.computeLabel(t, s);
        }
        return s.toString();
    }

    private void computeLabel(ITemplateParameter t, StringBuilder s) {
        if (t.isValueParameter()) {
            this.computeValueLabel(t, s);
        } else if (t.getOwnedParameterElement() != null) {
            this.computeParameterLabel(t, s);
        } else {
            s.append(t.getName());
            IModelElement type = t.getType();
            if (type != null) {
                if (type instanceof IClass) {
                    s.append(" ^ ");
                    s.append(type.getName());
                } else {
                    s.append(" : ");
                    s.append(type.getMetaclassName());
                }
            }
            if (t.getDefaultType() != null) {
                s.append(" = ");
                s.append(t.getDefaultType().getName());
            } else if (!t.getDefaultValue().isEmpty()) {
                s.append(" = ");
                s.append(t.getDefaultValue());
            }
        }
    }

    private void computeParameterLabel(ITemplateParameter t, StringBuilder s) {
        IModelElement paramElement = t.getOwnedParameterElement();
        if (paramElement instanceof INameSpace) {
            INameSpace ns = (INameSpace)paramElement;
            s.append(ns.getName());
            if (ns.cardParent() > 0) {
                s.append("^");
                for (IGeneralization g : ns.getParent()) {
                    s.append(g.getSuperType().getName());
                }
            }
        } else {
            s.append(paramElement.getName());
        }
        if (t.getDefaultType() != null) {
            s.append(" = ");
            s.append(t.getDefaultType().getName());
        } else if (!t.getDefaultValue().isEmpty()) {
            s.append(" = ");
            s.append(t.getDefaultValue());
        }
    }

    private void computeValueLabel(ITemplateParameter t, StringBuilder s) {
        s.append(t.getName());
        s.append(":");
        if (t.getType() != null) {
            s.append(t.getType().getName());
        }
        if (!t.getDefaultValue().isEmpty()) {
            s.append("=");
            s.append(t.getDefaultValue());
        }
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmTemplateSignature.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void obElementAdded(IElement addedEl) {
        if (addedEl instanceof ITemplateParameter) {
            this.refreshFromObModel();
        } else {
            super.obElementAdded(addedEl);
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmTemplateSignature.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.related = (INameSpace)this.resolveRef(this.getRepresentedRef());
    }

    public int getMajorVersion() {
        return 0;
    }
}

